% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focal2.R
\name{focal2}
\alias{focal2}
\title{Apply a 3x3 focal filter on a raster}
\usage{
focal2(r, fun, ...)
}
\arguments{
\item{r}{A raster (class \code{stars}) with two dimensions: \code{x} and \code{y}, i.e., a single-band raster}

\item{fun}{A function to be applied on each 3x3 neighborhood. The function needs to accepts a vector of length 9 and return a vector of length 1}

\item{...}{Further arguments passed to \code{fun}}
}
\value{
The filtered \code{stars} raster
}
\description{
Applies a 3x3 focal filter on a raster (class \code{stars}).
}
\note{
The raster is "padded" with one more row/column of \code{NA} values on all sides, so that the neigborhood of the outermost rows and columns is still a complete 3x3 neighborhood. Those rows and columns are removed from the filtered result before returning it.

This function provides a subset of the functionality that \code{focal} (package \code{raster}) has.
}
\examples{
library(stars)
dem1 = focal2(dem, mean, na.rm = TRUE)
dem2 = focal2(dem, min, na.rm = TRUE)
dem3 = focal2(dem, max, na.rm = TRUE)
r = c(dem, round(dem1, 1), dem2, dem3, along = 3)
r = st_set_dimensions(r, 3, values = c("input", "mean", "min", "max"))
plot(r, text_values = TRUE, breaks = "equal", col = terrain.colors(10))

}
