% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{NN}
\alias{NN}
\title{Finding the index of the NN of a given point}
\usage{
NN(x, i, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{i}{index of (i.e., row number for) the subject whose NN is to be found.}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the index (indices) i.e. row number(s) of the NN of subject \eqn{i}
}
\description{
Returns the index (or indices) of the nearest neighbor(s) of subject \eqn{i} given data set or IPD matrix \code{x}.
It will yield a \code{vector} if there are ties, and subject indices correspond to rows (i.e. rows \code{1:n} ) if \code{x} 
is the data set and to rows or columns if \code{x} is the IPD matrix.  

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.
}
\examples{
#3D data points
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
NN(ipd,1)
NN(Y,1,is.ipd = FALSE)
NN(ipd,5)
NN(Y,5,is.ipd = FALSE)
NN(Y,5,is.ipd = FALSE,method="max")

#1D data points
X<-as.matrix(runif(15)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(5) would not work
ipd<-ipd.mat(X)
NN(ipd,1)
NN(ipd,5)

#with possible ties in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ny<-nrow(Y)
ipd<-ipd.mat(Y)
for (i in 1:ny)
  cat(i,":",NN(ipd,i),"|",NN(Y,i,is.ipd = FALSE),"\n")

}
\seealso{
\code{\link{kNN}} and \code{\link{NNsub}}
}
\author{
Elvan Ceyhan
}
