% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{ind.seg.coeff}
\alias{ind.seg.coeff}
\title{Index Matrix for Computing the Covariance of Segregation Coefficients}
\usage{
ind.seg.coeff(k)
}
\arguments{
\item{k}{An integer specifying the number of classes in the data set}
}
\value{
The \eqn{k(k+1)/2 \times 2} index matrix with each row is the \eqn{i,j} 
corresponding to \eqn{N_{ij}} in the NNCT
}
\description{
Returns the index matrix for choosing the entries in the covariance matrix for NNCT 
used for computing the covariance for the extension of Pielou's segregation coefficient to the multi-class
case. The matrix is \eqn{k(k+1)/2 \times 2} with each row is the \eqn{i,j} 
corresponding to \eqn{N_{ij}} in the NNCT.
}
\seealso{
\code{\link{cov.seg.coeff}}, \code{\link{seg.coeff}} and \code{\link{ind.nnsym}}
}
\author{
Elvan Ceyhan
}
