% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsExpTrun}
\alias{funsExpTrun}
\alias{EV.Trun}
\alias{EV.Trun.alt}
\title{Expected Value for Cuzick and Edwards \eqn{T_{run}} Test statistic}
\usage{
EV.Trun(n1, n0)

EV.Trun.alt(n1, n0)
}
\arguments{
\item{n1, n0}{The number of cases and controls used as arguments for both functions.}
}
\value{
The expected value of Cuzick and Edwards \eqn{T_{run}} test statistic for disease clustering
}
\description{
Two functions: \code{EV.Trun} and \code{EV.Trun.alt}.

Both functions compute the expected value of Cuzick and Edwards \eqn{T_{run}} test statistic based on the number of 
consecutive cases from the cases in the data under RL or CSR independence.

The number of cases are denoted as \eqn{n_1} (denoted as \code{n1} as an argument)
and number of controls as \eqn{n_0} for both functions (denoted as \code{n0} as an argument),
to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

The function \code{EV.Trun.alt} uses a loop and takes slightly longer than the function \code{EV.Trun},
hence \code{EV.Trun} is used in other functions. 

See also (\insertCite{cuzick:1990;textual}{nnspat}).
}
\examples{
n1<-20
n0<-25

EV.Trun(n1,n0)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTrun}} and \code{\link{EV.Tk}}
}
\author{
Elvan Ceyhan
}
