% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{pick.min.max}
\alias{pick.min.max}
\title{Smallest and Largest Distances in a Distance Matrix}
\usage{
pick.min.max(ds, k = 1)
}
\arguments{
\item{ds}{A distance matrix or a distance object}

\item{k}{A positive integer representing the number of (min and max) distances to be presented, default is \eqn{k=1}}
}
\value{
A \code{list} with the elements
\item{min.dis}{The \code{k} smallest distances in \code{ds}}
\item{ind.min.dis}{The indices (i.e. row numbers) of the \code{k} pairs of object which has the
\code{k} smallest distances in \code{ds}}
\item{max.dis}{The \code{k} largest distances in \code{ds}}
\item{ind.max.dis}{The indices (i.e. row numbers) of the \code{k} pairs of object which has the
\code{k} largest distances in \code{ds}}
}
\description{
This function finds and returns the \code{k} smallest and \code{k} largest distances in a distance matrix or distance object,
and also provides pairs of objects these distances correspond to.
The code is adapted from 
\url{http://people.stat.sc.edu/Hitchcock/chapter1_R_examples.txt}.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
pick.min.max(ipd)
#or
pick.min.max(dist(Y))

pick.min.max(ipd,2)

}
\seealso{
\code{\link[stats]{dist}}, \code{\link{ipd.mat}}, and \code{\link{ipd.mat.euc}}
}
\author{
Elvan Ceyhan
}
