% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{docdb_get}
\alias{docdb_get}
\title{Get all documents from container in database}
\usage{
docdb_get(src, key, limit = NULL, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) A key as name of the container
(corresponds to parameter \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for SQLite and for PostgreSQL)}

\item{limit}{(integer) Maximum number of documents
to return (defaults 10,000 for Elasticsearch and
all for MongoDB, SQLite, CouchDB, PostgreSQL, and
DuckDB}

\item{...}{Passed on to functions:
\itemize{
\item MongoDB: find() in \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item SQLite: ignored
\item Elasticsearch: \code{\link[elastic:Search]{elastic::Search()}}
\item CouchDB: \code{\link[sofa:db_alldocs]{sofa::db_alldocs()}}
\item PostgreSQL: ignored
\item DuckDB: ignored
}}
}
\value{
Document(s) in a data frame
}
\description{
Get all documents from container in database
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars", limit = 10L)
}
}
