# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Maximum Likelihood Estimate under the sharp null for Compliers.
#'
#' Find the maximum likelihood estimate of the 2 by 4 contingency table
#'     assuming only Compliers and Never Takers in the population,
#'     under the sharp null for Compliers
#'     and with the multivariate hypergeometric sampling distribution.
#'     This is the C++ function for the R wrapper function
#'     \code{\link{FindMLE_CONT_H0_hypergeoR}}.
#'
#' @param n_y0x0z0 Number of individuals with Y=0, X=0, Z=0.
#' @param n_y1x0z0 Number of individuals with Y=1, X=0, Z=0.
#' @param n_y0x0z1 Number of individuals with Y=0, X=0, Z=1.
#' @param n_y1x0z1 Number of individuals with Y=1, X=0, Z=1.
#' @param n_y0x1z1 Number of individuals with Y=0, X=1, Z=1.
#' @param n_y1x1z1 Number of individuals with Y=1, X=1, Z=1.
#' @return The maximum likelihood under the sharp null for Compliers,
#'     and the corresponding (possibly non-unique)
#'     total number of Compliers of response types
#'     Never Recover and Always Recover.
FindMLE_CONT_H0_hypergeoC <- function(n_y0x0z0, n_y1x0z0, n_y0x0z1, n_y1x0z1, n_y0x1z1, n_y1x1z1) {
    .Call('noncompliance_FindMLE_CONT_H0_hypergeoC', PACKAGE = 'noncompliance', n_y0x0z0, n_y1x0z0, n_y0x0z1, n_y1x0z1, n_y0x1z1, n_y1x1z1)
}

#' Maximum Likelihood Estimate without assuming the sharp null for Compliers.
#'
#' Find the maximum likelihood estimate of the 2 by 4 contingency table
#'     assuming only Compliers and Never Takers in the population,
#'     with the multivariate hypergeometric sampling distribution.
#'     This is the C++ function for the R wrapper function
#'     \code{\link{FindMLE_CONT_H1_hypergeoR}}.
#'
#' @inheritParams FindMLE_CONT_H0_hypergeoC
#' @return The maximum likelihood and the corresponding
#'     (possibly non-unique) number of Compliers in each Z arm.
FindMLE_CONT_H1_hypergeoC <- function(n_y0x0z0, n_y1x0z0, n_y0x0z1, n_y1x0z1, n_y0x1z1, n_y1x1z1) {
    .Call('noncompliance_FindMLE_CONT_H1_hypergeoC', PACKAGE = 'noncompliance', n_y0x0z0, n_y1x0z0, n_y0x0z1, n_y1x0z1, n_y0x1z1, n_y1x1z1)
}

#' Finite population sample space given an observed dataset.
#'
#' Sample space of all possibly observable datasets given an observed dataset,
#'     assuming only Compliers and Never Takers in the population.
#'     This is the C++ function for the R wrapper function
#'     \code{\link{AllPossiblyObsH0_CONT}}.
#'
#' @param obs_y0x0z0 Number of observed individuals with Y=0, X=0, Z=0.
#' @param obs_y1x0z0 Number of observed individuals with Y=1, X=0, Z=0.
#' @param obs_y0x0z1 Number of observed individuals with Y=0, X=0, Z=1.
#' @param obs_y1x0z1 Number of observed individuals with Y=1, X=0, Z=1.
#' @param obs_y0x1z1 Number of observed individuals with Y=0, X=1, Z=1.
#' @param obs_y1x1z1 Number of observed individuals with Y=1, X=1, Z=1.
#' @return All possibly observable datasets in a list format.
AllPossiblyObsH0_CONT_C <- function(obs_y0x0z0, obs_y1x0z0, obs_y0x0z1, obs_y1x0z1, obs_y0x1z1, obs_y1x1z1) {
    .Call('noncompliance_AllPossiblyObsH0_CONT_C', PACKAGE = 'noncompliance', obs_y0x0z0, obs_y1x0z0, obs_y0x0z1, obs_y1x0z1, obs_y0x1z1, obs_y1x1z1)
}

#' Finite population sample space given an observed dataset.
#'
#' Sample space of all possibly observable datasets given an observed dataset,
#'     assuming only Compliers and Never Takers in the population.
#'     The maximum likelihood estimate is also calculated for each dataset.
#'     This is the C++ function for the R wrapper function
#'     \code{\link{AllPossiblyObsH0_CONT}}.
#'
#' @inheritParams AllPossiblyObsH0_CONT_C
#' @return All possibly observable datasets in a list format.
AllPossiblyObsH0qH1_CONT_C <- function(obs_y0x0z0, obs_y1x0z0, obs_y0x0z1, obs_y1x0z1, obs_y0x1z1, obs_y1x1z1) {
    .Call('noncompliance_AllPossiblyObsH0qH1_CONT_C', PACKAGE = 'noncompliance', obs_y0x0z0, obs_y1x0z0, obs_y0x0z1, obs_y1x0z1, obs_y0x1z1, obs_y1x1z1)
}

#' Exact finite population p-values under the sharp null for Compliers.
#'
#' Find the exact population-specific p-values
#'     under the sharp null for Compliers,
#'     for each compatible population with only Compliers and Never Takers.
#'     This is the C++ function for the R wrapper function
#'     \code{\link{Get_pvalues_CONT}}.
#'
#' @param n_y0x0z0_H0 Number of individuals with Y=0, X=0, Z=0.
#' @param n_y1x0z0_H0 Number of individuals with Y=1, X=0, Z=0.
#' @param n_y0x0z1_H0 Number of individuals with Y=0, X=0, Z=1.
#' @param n_y1x0z1_H0 Number of individuals with Y=1, X=0, Z=1.
#' @param n_y0x1z1_H0 Number of individuals with Y=0, X=1, Z=1.
#' @param n_y1x1z1_H0 Number of individuals with Y=1, X=1, Z=1.
#' @param n_NTy0_H0 Total number of Never Takers with Y=0.
#' @param n_CONR_H0 Total number of Compliers of response type
#'     Never Recover.
#' @param n_COAR_H0 Total number of Compliers of response type
#'     Always Recover.
#' @param n_NTy1_H0 Total number of Never Takers with Y=1.
#' @param critical_regions Matrix denoting whether each
#'     possibly observed dataset (rows) is in a critical region
#'     (columns).
#' @return A matrix of p-values correspnding to each population
#'     (row) and the critical region (columns).
GetPvalueshypergeoC_allpsi_CONT <- function(n_y0x0z0_H0, n_y1x0z0_H0, n_y0x0z1_H0, n_y1x0z1_H0, n_y0x1z1_H0, n_y1x1z1_H0, n_NTy0_H0, n_CONR_H0, n_COAR_H0, n_NTy1_H0, critical_regions) {
    .Call('noncompliance_GetPvalueshypergeoC_allpsi_CONT', PACKAGE = 'noncompliance', n_y0x0z0_H0, n_y1x0z0_H0, n_y0x0z1_H0, n_y1x0z1_H0, n_y0x1z1_H0, n_y1x1z1_H0, n_NTy0_H0, n_CONR_H0, n_COAR_H0, n_NTy1_H0, critical_regions)
}

