% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{as.bootstrap}
\alias{as.bootstrap}
\alias{as.bootstrap.bootstrap}
\alias{as.bootstrap.character}
\title{Create a Bootstrap Table}
\usage{
as.bootstrap(x, ...)

\method{as.bootstrap}{bootstrap}(x, ...)

\method{as.bootstrap}{character}(
  x,
  skip = 28,
  check.names = FALSE,
  lo = "5",
  hi = "95",
  verbose = TRUE,
  pattern = "bootstrap_results.csv",
  bootcsv = dir(modeldir(x, ...), pattern = pattern, recursive = TRUE, full.names = TRUE),
  ...
)
}
\arguments{
\item{x}{object of dispatch}

\item{...}{arguments to methods}

\item{skip}{number of lines to skip in bootstrap_results.csv}

\item{check.names}{passed to bootstrap reader}

\item{lo}{the PsN bootstrap lower confidence limit (\%)}

\item{hi}{the PsN bootstrap upper confidence limit (\%)}

\item{verbose}{display messages}

\item{pattern}{pattern to search for bootstrap file}

\item{bootcsv}{path to bootstrap_results.csv or equivalent}
}
\value{
data.frame

data.frame

data.frame
}
\description{
Creates a bootstrap table.

Creates bootstrap from bootstrap.

Creates a bootstrap table from a PsN bootstrap results csv filepath. If \code{x} is not an existing file it is treated as a modelname and the results file is sought.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.bootstrap(bootstrap)}: bootstrap method

\item \code{as.bootstrap(character)}: character method

}}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% as.bootstrap
}
\seealso{
\code{\link{as.bootstrap.character}}

Other as.bootstrap: 
\code{\link{as.bootstrap.numeric}()}

Other as.bootstrap: 
\code{\link{as.bootstrap.numeric}()}

Other as.bootstrap: 
\code{\link{as.bootstrap.numeric}()}
}
\concept{as.bootstrap}
\keyword{internal}
