% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_pmm.R
\name{method_pmm}
\alias{method_pmm}
\title{Mass imputation using predictive mean matching method}
\usage{
method_pmm(
  y_nons,
  X_nons,
  X_rand,
  svydesign,
  weights = NULL,
  family_outcome = "gaussian",
  start_outcome = NULL,
  vars_selection = FALSE,
  pop_totals = NULL,
  pop_size = NULL,
  control_outcome = control_out(),
  control_inference = control_inf(),
  verbose = FALSE,
  se = TRUE
)
}
\arguments{
\item{y_nons}{target variable from non-probability sample}

\item{X_nons}{a \code{model.matrix} with auxiliary variables from non-probability sample}

\item{X_rand}{a \code{model.matrix} with auxiliary variables from non-probability sample}

\item{svydesign}{a svydesign object}

\item{weights}{case / frequency weights from non-probability sample}

\item{family_outcome}{family for the glm model}

\item{start_outcome}{start parameters}

\item{vars_selection}{whether variable selection should be conducted}

\item{pop_totals}{a place holder (not used in \code{method_pmm})}

\item{pop_size}{population size from the \code{nonprob} function}

\item{control_outcome}{controls passed by the \code{control_out} function}

\item{control_inference}{controls passed by the \code{control_inf} function}

\item{verbose}{parameter passed from the main \code{nonprob} function}

\item{se}{whether standard errors should be calculated}
}
\value{
an \code{nonprob_method} class which is a \code{list} with the following entries

\describe{
\item{model_fitted}{fitted model either an \code{glm.fit} or \code{cv.ncvreg} object}
\item{y_nons_pred}{predicted values for the non-probablity sample}
\item{y_rand_pred}{predicted values for the probability sample or population totals}
\item{coefficients}{coefficients for the model (if available)}
\item{svydesign}{an updated \code{surveydesign2} object (new column \code{y_hat_MI} is added)}
\item{y_mi_hat}{estimated population mean for the target variable}
\item{vars_selection}{whether variable selection was performed}
\item{var_prob}{variance for the probability sample component (if available)}
\item{var_nonprob}{variance for the non-probability sampl component}
\item{model}{model type (character \code{"pmm"})}
\item{family}{depends on the method selected for estimating E(Y|X)}
}
}
\description{
Model for the outcome for the mass imputation estimator. The implementation is currently based on \link[RANN:nn2]{RANN::nn2} function and thus it uses Euclidean distance for matching units from \eqn{S_A} (non-probability) to \eqn{S_B} (probability) based on predicted values from model \eqn{\boldsymbol{x}_i} based
either on \code{method_glm} or \code{method_npar}. Estimation of the mean is done using \eqn{S_B} sample.

This implementation extends Yang et al. (2021) approach as described in Chlebicki et al. (2025), namely:

\describe{
\item{pmm_weights}{if k>1 weighted aggregation of the mean for a given unit is used. We use distance
matrix returned by \link[RANN:nn2]{RANN::nn2} function (\code{pmm_weights} from the \code{\link[=control_out]{control_out()}} function)}
\item{nn_exact_se}{if the non-probability sample is small we recommend using a mini-bootstrap
approach to estimate variance from the non-probability sample  (\code{nn_exact_se} from the \code{\link[=control_inf]{control_inf()}} function)}
\item{pmm_k_choice}{the main \code{nonprob} function allows for dynamic selection of \code{k} neighbours based on the
variance minimization procedure (\code{pmm_k_choice} from the \code{\link[=control_out]{control_out()}} function)}
}
}
\details{
Matching

In the package we support two types of matching:
\enumerate{
\item \eqn{\hat{y} - \hat{y}} matching (default; \code{control_out(pmm_match_type = 1)}).
\item \eqn{\hat{y} - y} matching (\code{control_out(pmm_match_type = 2)}).
}

Analytical variance

The variance of the mean is estimated based on the following approach
(a) non-probability part  (\eqn{S_A} with size \eqn{n_A}; denoted as \code{var_nonprob} in the result) is currently estimated using the non-parametric mini-bootstrap estimator proposed by
Chlebicki et al. (2025, Algorithm 2). It is not proved to be consistent but with good finite population properties.
This bootstrap can be applied using \code{control_inference(nn_exact_se=TRUE)} and
can be summarized as follows:
\enumerate{
\item Sample \eqn{n_A} units from \eqn{S_A} with replacement to create \eqn{S_A'} (if pseudo-weights are present inclusion probabilities should be proportional to their inverses).
\item Estimate regression model \eqn{\mathbb{E}[Y|\boldsymbol{X}]=m(\boldsymbol{X}, \cdot)} based on \eqn{S_{A}'} from step 1.
\item Compute \eqn{\hat{\nu}'(i,t)} for \eqn{t=1,\dots,k, i\in S_{B}} using estimated \eqn{m(\boldsymbol{x}', \cdot)} and \eqn{\left\lbrace(y_{j},\boldsymbol{x}_{j})| j\in S_{A}'\right\rbrace}.
\item Compute \eqn{\displaystyle\frac{1}{k}\sum_{t=1}^{k}y_{\hat{\nu}'(i)}} using \eqn{Y} values from \eqn{S_{A}'}.
\item Repeat steps 1-4 \eqn{M} times (we set (hard-coded) \eqn{M=50} in our code).
\item Estimate \eqn{\hat{V}_1=\text{var}({\hat{\boldsymbol{\mu}}})} obtained from simulations and save it as \code{var_nonprob}.
}

(b) probability part (\eqn{S_B} with size \eqn{n_B}; denoted as \code{var_prob} in the result)

This part uses functionalities of the \code{{survey}} package and the variance is estimated using the following
equation:

\deqn{
\hat{V}_2=\frac{1}{N^2} \sum_{i=1}^{n_B} \sum_{j=1}^{n_B} \frac{\pi_{i j}-\pi_i \pi_j}{\pi_{i j}}
\frac{m(\boldsymbol{x}_i; \hat{\boldsymbol{\beta}})}{\pi_i} \frac{m(\boldsymbol{x}_i; \hat{\boldsymbol{\beta}})}{\pi_j}.
}

Note that \eqn{\hat{V}_2} in principle can be estimated in various ways depending on the type of the design and whether population size is known or not.
}
\examples{

data(admin)
data(jvs)
jvs_svy <- svydesign(ids = ~ 1,  weights = ~ weight, strata = ~ size + nace + region, data = jvs)

res_pmm <- method_pmm(y_nons = admin$single_shift,
                      X_nons = model.matrix(~ region + private + nace + size, admin),
                      X_rand = model.matrix(~ region + private + nace + size, jvs),
                      svydesign = jvs_svy)

res_pmm

}
