% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_news.R
\name{gen_news}
\alias{gen_news}
\title{Viewing the impact of new data on a nowcast.}
\usage{
gen_news(old_y, new_y, output_dfm, target_variable, target_period)
}
\arguments{
\item{old_y}{dataframe of variables, size (n_obs, n_variables). Must include in 1st column a series of type date, called "date", all data already stationary.}

\item{new_y}{dataframe of variables, size (n_obs, n_variables). Must include in 1st column a series of type date, called "date", all data already stationary. Must contain same columns as old_y.}

\item{output_dfm}{list, the output of the \code{dfm()} function.}

\item{target_variable}{name of the target column.}

\item{target_period}{date of forecast to view impacts on.}
}
\value{
A \code{list} containing the following elements:
\item{target_period}{same as input.}
\item{target_variable}{same as input.}
\item{y_old}{forecast for target variable with old data.}
\item{y_new}{forecast for target variable with new data.}
\item{forecast}{forecast of variables for target period. Only shows for variables that were newly published between old and new dataset.}
\item{actual}{actual published value of variables for target period. Only shows for variables that were newly published between old and new dataset.}
\item{weight}{weight of each data release}
\item{news_table}{table summarising forecast, actual, weight and impact of data releases}
\item{impact_revisions}{impact of data revisions on nowcast.}
\item{impact_releases}{impact of data releases on nowcast.}
\item{impact_total}{total impact (from data revision and data releases).}
}
\description{
given and old and new dataset, will calculate the impact data releases and revisions have on the estimate of a target variable.
}
