% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quade.r
\name{Quade}
\alias{Quade}
\title{Quade Method for Nonparametric ANCOVA}
\usage{
Quade(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate1 + ... + group`.}
}
\value{
A list containing the following components:
\describe{
  \item{regression_equation}{Summary of the linear model regressing the ranked response on the ranked covariates.}
  \item{anova_summary}{The summary of the ANOVA model performed on the residuals.}
  \item{group_means}{A data frame of the mean of residuals for each group.}
  \item{group_sds}{A data frame of the standard deviation of residuals for each group.}
  \item{regression_equation_residuals}{The summary of the model fitting residuals on the group.}
  \item{data}{The original data frame augmented with ranked variables and residuals.}
}
}
\description{
Performs Quade's ANCOVA using ranked variables and analysis of residuals.
The method fits a linear model of the ranked response on the ranked covariates,
and then performs an ANOVA on the residuals of that model.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35),
  covariate2 = c(12, 21, 24, 29, 34, 17, 2, 40, 38, 36, 8, 1, 9, 28, 16)
)

# 2. Run the Quade method
results <- Quade(
  formula = response ~ covariate1 + covariate2 + group,
  data = data
)

# 3. View the results
print(results)
print(results$anova_summary)

}
\references{
Quade DJJotASA. Rank analysis of covariance. 1967;62(320):1187-200.

Olejnik SF, Algina JJER. A review of nonparametric alternatives to analysis of covariance. 1985;9(1):51-83.
}
