% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProcessData.R
\name{ProcessData}
\alias{ProcessData}
\title{Process data set.}
\usage{
ProcessData(data, tx, period, subject, resp, indicator=NULL)
}
\arguments{
\item{data}{a data frame in the long format.}

\item{tx}{treatment variable.}

\item{period}{time indicator variable.}

\item{subject}{subject or cluster ID}

\item{resp}{response variable to be analyzed.}

\item{indicator}{an optional vector of characters indicating the order of pre and post intervention period;
must match the levels of period argument if specified; if not specified, the pre and post intervention
period will be ordered in the alphabet order by default}
}
\value{
a list containing the following components:
\describe{
  \item{\code{trt }}{number of treatments}
  \item{\code{nc }}{complete cluster sample size within each treatment group}
  \item{\code{n1 }}{incomplete cluster sample size pre intervention within each treatment group}
  \item{\code{n2 }}{incomplete cluster sample size post intervention within each treatment group}
  \item{\code{m1c }}{complete cluster sizes pre-intervention within each treatment group}
  \item{\code{m2c }}{complete cluster size post-intervention within each treatment group}
  \item{\code{m1i }}{incomplete cluster sizes pre-intervention within each treatment group}
  \item{\code{m2i }}{incomplete cluster sizes post-intervention within each treatment group}
  \item{\code{x1c }}{complete data pre-intervention within each treatment group}
  \item{\code{x2c }}{complete data post-intervention within each treatment group}
  \item{\code{x1i }}{incomplete data pre-intervention within each treatment group}
  \item{\code{x2i }}{incomplete data post-intervention within each treatment group}
}
}
\description{
Sample size and cluster size calculation for the imported data set.
}
\examples{
ARTIS_result <- ProcessData(ARTIS, tx, intervention, homeid, symptoms_pqol,
                            c("0","1"))
names(ARTIS_result)
skin_result <- ProcessData(skin, tx, intervention, subject, score,
                           c("control","treatment"))
skin_result$nc
skin_result$n1
skin_result$n2
}
