% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-plotHazSurv.R
\name{plotHazSurv}
\alias{plotHazSurv}
\title{Graphic Display of Hazard and Survival Function}
\usage{
plotHazSurv(
  bsl_dist = c("weibull", "loglogistic"),
  param = c(1.2, 0.03),
  fun_list,
  end,
  tit = c("Hazard Function", "Survival Function"),
  pos = c(1, 2),
  hlegend.loc = "bottomleft"
)
}
\arguments{
\item{bsl_dist}{a text must be one of (\code{"weibull"},
\code{"loglogistic"}) distribution, specified for the control group}

\item{param}{a vector of length 2, specifying the shape and rate (1/scale)
parameter of the \code{bsl_dist} distribution, Default: c(1.2, 0.03)}

\item{fun_list}{a list of hazard ratio functions comparing treatment group
and control group}

\item{end}{a value specifying the duration of the curve}

\item{tit}{a vector specifying the titles of each graph, Default: c("Hazard Function", "Survival Function")}

\item{pos}{a graphic parameter in the form of c(nr,nc). Subsequent
figures will be drawn in an nr-by-nc array, Default: c(1, 2)}

\item{hlegend.loc}{a text indicating the position of legend
for the hazard plot. Default: "bottomleft"}
}
\value{
graphics of hazard and survival functions
}
\description{
Plot the hazard and survival function of the
of control group (from weibull or loglogistic distribution) and treatment group
(derived from an arbitrary hazard ratio function)
}
\examples{
# proportional hazards
plotHazSurv(
 bsl_dist=c("weibull")
 ,param=c(1.2,1/30)
 ,fun_list=list(function(x){x^0*0.7})
 ,40
 ,tit= c("Hazard Function","Survival Function")
 ,pos=c(1,2)
)
# crossing hazards
plotHazSurv(
 bsl_dist=c("weibull")
 ,param=c(1.2,1/30)
 ,fun_list=list(function(x){1.3*(x<10)+(x>=10)*0.7})
 ,40
 ,tit= c("Hazard Function","Survival Function")
 ,pos=c(1,2)
)
}
