#' Copyright(c) 2017-2020 R. Mark Sharp
#' This file is part of nprcgenekeepr
context("convertStatusCodes")
library(testthat)
original <- c("A", "alive", "Alive", "1", "S", "Sale", "sold", "shipped",
              "D", "d", "dead", "died", "deceased", "2",
              "shiped", "3", "U", "4", "unknown", NA,
              "Unknown", "H", "hermaphrodite", "U", "Unknown", "4")
status <- convertStatusCodes(original)
test_that("convertStatusCodes makes correct transformations", {
  expect_true(is.factor(status))
  status <- as.character(status)
  expect_equal(status[1], "ALIVE")
  expect_equal(status[2], "ALIVE")
  expect_equal(status[3], "ALIVE")
  expect_equal(status[4], "ALIVE")
  expect_equal(status[5], "SHIPPED")
  expect_equal(status[6], "SHIPPED")
  expect_equal(status[7], "SHIPPED")
  expect_equal(status[8], "SHIPPED")
  expect_equal(status[9], "DECEASED")
  expect_equal(status[10], "DECEASED")
  expect_equal(status[11], "DECEASED")
  expect_equal(status[12], "DECEASED")
  expect_equal(status[13], "DECEASED")
  expect_equal(status[14], "DECEASED")
  expect_equal(status[15], "SHIPPED")
  expect_equal(status[16], "SHIPPED")
  expect_equal(status[17], "UNKNOWN")
  expect_equal(status[18], "UNKNOWN")
  expect_equal(status[19], "UNKNOWN")
  expect_equal(status[20], "UNKNOWN")
  expect_equal(status[21], "UNKNOWN")
  expect_equal(status[22], as.character(NA))
  expect_equal(status[23], as.character(NA))
  expect_equal(status[24], "UNKNOWN")
  expect_equal(status[25], "UNKNOWN")
  expect_equal(status[26], "UNKNOWN")
})
