% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical.R
\name{critical}
\alias{critical}
\title{Critical points of the regression function}
\usage{
critical(model, der = NULL)
}
\arguments{
\item{model}{Parametric or nonparametric regression out 
obtained by \code{\link{frfast}} function.}

\item{der}{Number which determines any inference process. By default
\code{der} is \code{NULL}. If this term is \code{0}, the calculation is for
the point which maximize the estimate. If it is \code{1} it is 
designed for the first derivative and if it is \code{2}, it returns the point
 which equals the second derivative to zero.}
}
\value{
An object is returned with the following elements:
\item{Estimation}{ \code{x} value which maximize the regression function with 
their 95\% confidence intervals (for each level).}
\item{First_der}{\code{x} value which maximize the first derivative with their
95\% confidence intervals (for each level).}
\item{Second_der}{\code{x} value which equals the second derivative to zero 
with their 95\% confidence intervals (for each level).}
}
\description{
This function draws inference about some critical point in 
the support of \eqn{X} which is associated  with  some features of the regression
function (e.g., minimum, maximum or inflection points which indicate changes
in the sign of curvature). Returns the value of the covariate \code{x} 
which maximizes the estimate of the function, the value of the covariate 
\code{x} which maximizes the first derivative and the value of the covariate 
\code{x} which equals the second derivative to zero, for each level of the 
factor.
}
\examples{
library(npregfast)
data(barnacle)

fit <- frfast(DW ~ RC, data = barnacle) # without interactions
critical(fit)
critical(fit, der = 0)
critical(fit, der = 1)
critical(fit, der = 2)

# fit2 <- frfast(DW ~ RC : F, data = barnacle) # with interactions
# critical(fit2)
# critical(fit2, der = 0)
# critical(fit2, der = 1)
# critical(fit2, der = 2)

}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\references{
Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.
}

