% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nproc.R
\name{nproc}
\alias{nproc}
\title{Calculate the Neyman-Pearson Receiver Operating Characteristics}
\usage{
nproc(x = NULL, y, method = c("logistic", "penlog", "svm", "randomforest",
  "lda", "nb", "ada", "tree", "custom"), score = NULL, band = FALSE,
  typeI.lower = FALSE, delta = 0.05, split = 1, split.ratio = 0.5,
  n.cores = 1, randSeed = 0, ...)
}
\arguments{
\item{x}{n * p observation matrix. n observations, p covariates.}

\item{y}{n 0/1 observatons.}

\item{method}{classification method(s).
\itemize{
\item logistic: Logistic regression. \link{glm} function with family = 'binomial'
\item penlog: Penalized logistic regression with LASSO penalty. \code{\link[glmnet]{glmnet}} in \code{glmnet} package
\item svm: Support Vector Machines. \code{\link[e1071]{svm}} in \code{e1071} package
\item randomforest: Random Forest. \code{\link[randomForest]{randomForest}} in \code{randomForest} package
\item Linear Discriminant Analysis. lda: \code{\link[MASS]{lda}} in \code{MASS} package
\item nb: Naive Bayes. \code{\link[e1071]{naiveBayes}} in \code{e1071} package
\item ada: Ada-Boost. \code{\link[ada]{ada}} in \code{ada} package
\item custom: a custom classifier. score vector needed.
}}

\item{score}{score vector corresponding to y. Required when method  = 'custom'.}

\item{band}{whether to generate two NP-ROC curves representing a confidence band. Default = FALSE.}

\item{typeI.lower}{whether to generate the data-driven type-I error lower bound. NOTE: experimental feature. Default = FALSE.}

\item{delta}{the violation rate of the type I error. Default = 0.05.}

\item{split}{the number of splits for the class 0 sample. Default = 1. For ensemble
version, choose split > 1.  When method = 'custom',  split = 0 always.}

\item{split.ratio}{the ratio of splits used for the class 0 sample to train the
classifier. Default = 0.5.}

\item{n.cores}{number of cores used for parallel computing. Default = 1.}

\item{randSeed}{the random seed used in the algorithm.}

\item{...}{additional arguments.}
}
\value{
An object with S3 class nproc.
\item{typeI.u}{sequence of upper bound of type I error.}
\item{typeII.l}{sequence of lower bound of type I error.}
\item{typeII.u}{sequence of upper bound of type II error.}
\item{auc.l}{the auc value of the lower NP-ROC curve.}
\item{auc.u}{the auc value of the upper NP-ROC curve.}
\item{band}{whether the upper NP-ROC curve is generated.}
\item{method}{the classification method implemented.}
\item{delta}{the violation rate.}
}
\description{
\code{nproc} calculate the Neyman-Pearson Receiver Operating Characteristics
curve for a given sequence of type I error values.
}
\examples{
n = 200
x = matrix(rnorm(n*2),n,2)
c = 1 - 3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
#fit = nproc(x, y, method = 'svm')
fit2 = nproc(x, y, method = 'penlog')
##Plot the nproc curve
plot(fit2)

##custom method
fit.npc = npc(x, y, method = 'svm')
fit.score = predict(fit.npc,x)$pred.score
fit.custom = nproc(y = y, score = fit.score, method = 'custom')

#fit3 = nproc(x, y, method = 'penlog')

##Plot the nproc curve
#plot(fit3)

#fit3 = nproc(x, y, method = 'penlog',  n.cores = 2)
#In practice, replace 2 by the number of cores available 'detectCores()'
#fit4 = nproc(x, y, method = 'penlog', n.cores = detectCores())

#Testing the custom method for nproc.
#fit = npc(x, y, method = 'lda', split = 0,  n.cores = 2) #use npc to get score list.
#obj = nproc(x = NULL, y = fit$y, method = 'custom', split = 0,
#score = fit$score,  n.cores = 2)

#Confidence nproc curves
#fit6 = nproc(x, y, method = 'lda', band = TRUE)

#nproc ensembled version
#fit7 = nproc(x, y, method = 'lda', split = 11)
}
\references{
Xin Tong, Yang Feng, and Jingyi Jessica Li (2016), Neyman-Pearson (NP) classification algorithms and NP receiver operating characteristic (NP-ROC), manuscript, http://arxiv.org/abs/1608.03109
}
\seealso{
\code{\link{npc}}
}

