% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{outline}
\alias{outline}
\title{New South Wales outline with or without related territories}
\usage{
outline(lord_howe_island = FALSE, act_cutout = FALSE, jervis_bay = TRUE)
}
\arguments{
\item{lord_howe_island}{Include Lord Howe Island.}

\item{act_cutout}{Cut out the area of the Australian Capital Territory.}

\item{jervis_bay}{Cover the area of the Jervis Bay Territory.}
}
\value{
A simple features data frame with the requested geometries.
}
\description{
The default outline \code{nswgeo::nsw} includes Jervis Bay Territory, excludes
Lord Howe Island, and does not have a cut out for the ACT. This utility
allows each of these to be adjusted.
}
\examples{
library(ggplot2)

outline(lord_howe_island = TRUE) |> ggplot() + geom_sf()
}
\seealso{
\link{nsw}
}
