% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levy_recovery.R
\name{fit_ghyp_diffusion}
\alias{fit_ghyp_diffusion}
\title{Fit a Generalised Hyperbolic distribution.}
\usage{
fit_ghyp_diffusion(data, ghyp_names = "FULL", silent = TRUE, ...)
}
\arguments{
\item{data}{Data to fit.}

\item{ghyp_names}{Ghyp distribution names
(in \code{c('NIG', 'GAUSS', 'VG', 'ST', 'FULL')}).}

\item{silent}{Boolean to silence the noise inference.}

\item{...}{Extra options given to the ghyp fitting.}
}
\value{
List of fitted Generalised Hyperbolic distribution.
}
\description{
Fit a Generalised Hyperbolic distribution.
}
\note{
\code{ghyp} fitting is forced to be silent.
}
\examples{
n <- 500
data <- cbind(ghyp::rghyp(n, ghyp::ghyp()), ghyp::rghyp(n, ghyp::ghyp()))
fit_ghyp_diffusion(data = data, silent = TRUE)
}
