% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather.R
\docType{data}
\name{weather}
\alias{weather}
\title{Hourly weather data}
\format{A data frame with columns
\describe{
\item{origin}{Weather station. Named \code{origin} to facilitate merging with
\code{\link{flights}} data.}
\item{year, month, day, hour}{Time of recording.}
\item{temp, dewp}{Temperature and dewpoint in F.}
\item{humid}{Relative humidity.}
\item{wind_dir, wind_speed, wind_gust}{Wind direction (in degrees), speed
and gust speed (in mph).}
\item{precip}{Precipitation, in inches.}
\item{pressure}{Sea level pressure in millibars.}
\item{visib}{Visibility in miles.}
\item{time_hour}{Date and hour of the recording as a \code{POSIXct} date.}
}}
\source{
ASOS download from Iowa Environmental Mesonet,
\url{https://mesonet.agron.iastate.edu/request/download.phtml}.
}
\usage{
weather
}
\description{
Hourly meterological data for LGA, JFK and EWR.
}
\keyword{datasets}
