% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_nzffd.R
\name{nzffd_fill}
\alias{nzffd_fill}
\title{Add additional data to the NZFFD}
\usage{
nzffd_fill(fishd, alt = TRUE, maps = TRUE)
}
\arguments{
\item{fishd}{A dataframe imported from the NZFFD using \code{nzffd_import}.}

\item{alt}{Should missing elevation data be added to the dataframe.}

\item{maps}{Should missing map tiles be added to the dataframe.}
}
\value{
A dataframe with the same number of rows as \code{fishd} but with
seven additional columns added (\code{common_name, sci_name, family, genus, species, threat_class, native}).
}
\description{
Adds columns for family, genus, species and common names, the species threat
classification status, whether the species is native or exotic. 
Also add missing values for the \code{map} and \code{alt} variables.
}
\details{
Altitude data is added by taking the site coordinates and pulling the relevant
data from an 8m \href{https://data.linz.govt.nz/layer/51768-nz-8m-digital-elevation-model-2012/}{DEM}. Note data taken from the DEM is suitable for cartographic visualisation only.


If \code{alt = TRUE} this function requires an internet connection to query
the 8m DEM.
}
\examples{
\dontrun{

df <- nzffd_fill(nzffdr::nzffd_data)
head(df)
}
}
