% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weather_data.R
\name{get_weather_data}
\alias{get_weather_data}
\title{Load weather data via API}
\usage{
get_weather_data(
  midterm_demand_data,
  api_key = "default",
  data_directory = tempdir()
)
}
\arguments{
\item{midterm_demand_data}{Dataframe. The mid-term data series from \code{\link{decompose_load_data}} with added holidays resulting from the function \code{\link{add_holidays_mid_term}}.}

\item{api_key}{Character. A valid API key from rapidapi that is subscribed to wft-geo-db and meteostat. If set to "default", one of the deposited keys will be used.}

\item{data_directory}{The path to the directory where the data will be saved.}
}
\value{
A list containing the mid-term data and temperature data.
}
\description{
This function loads weather data which is used to forecast the mid-term load seasonalities.
First the 20 most populated areas in the country are obtained from https://wft-geo-db.p.rapidapi.com . Then the closest weather stations of each area are identified and average daily temperature values are downloaded from https://meteostat.p.rapidapi.com  for the provided time period.
From this data a weighted daily average temperature based on population is calculated for the provided country.
}
\examples{
example_midterm_demand_and_weather_data <- get_weather_data(example_midterm_demand_data,
  api_key = "default"
)
head(example_midterm_demand_and_weather_data$demand)
head(example_midterm_demand_and_weather_data$temperature_data)
}
\seealso{
See function \code{\link{decompose_load_data}} for the generation of the mid-term series.
}
