% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oasis_preproc.R
\name{oasis_preproc}
\alias{oasis_preproc}
\title{OASIS Image Preprocessing}
\usage{
oasis_preproc(flair, t1, t2, pd, brain_mask = NULL, verbose = TRUE,
  cores = 1)
}
\arguments{
\item{flair}{FLAIR volume of class \code{\link{nifti}}}

\item{t1}{T1 volume of class \code{\link{nifti}}}

\item{t2}{T2 volume of class \code{\link{nifti}}}

\item{pd}{PD volume of class \code{\link{nifti}}}

\item{brain_mask}{binary mask volume of class \code{\link{nifti}}}

\item{verbose}{a logical value for printing diagnostic output}

\item{cores}{numeric indicating the number of cores to be used (no more than 4 is useful for this software implementation)}
}
\value{
Returns a list of objects of class \code{\link{nifti}}, 
namely the inhomogeneity corrected FLAIR, T1, T2, and PD registered to the 
space of the T1 volume.
}
\description{
This function does the required preprocessing for OASIS for the FLAIR, T2, 
T1, and PD volumes using FSL through \code{fslr}.  
The preprocessing steps are 
(1) inhomogeneity correct using \code{\link{fsl_biascorrect}}
and (2) rigid registration using \code{\link{flirt}} to the T1 space.
}
\examples{
\dontrun{
library(fslr)
flair <- readnii('path/to/flair', reorient = FALSE) 
t1 <- readnii('path/to/t1', reorient = FALSE) 
t2 <- readnii('path/to/t2', reorient = FALSE) 
pd <- readnii('path/to/pd', reorient = FALSE)
oasis_preprocessed_data <- oasis_preproc(flair, t1, t2, pd) 
}
}

