% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{humanDetection}
\alias{humanDetection}
\title{Hyper Human Influence}
\usage{
humanDetection(
  df,
  xf,
  yf,
  method = "all",
  ras.hii,
  .th.human.influence,
  .points.proj4string,
  do = TRUE,
  verbose = FALSE,
  output.dir
)
}
\arguments{
\item{df}{Data.frame of species occurrences}

\item{xf}{the field in the data frame containing the x coordinates}

\item{yf}{the field in the data frame containing the y coordinates}

\item{method}{character. Indicate which tests to use. Default 'all'. See Details}

\item{ras.hii}{raster. Raster map of human influence index use}

\item{.th.human.influence}{numeric. Threhold to identify places of high human influence}

\item{.points.proj4string}{proj4string argument for df}

\item{do}{logical. Should range analysis be performed? Default TRUE}

\item{verbose}{logical. Print messages? Default FALSE}

\item{output.dir}{character. Output directory}
}
\value{
data.frame
}
\description{
Detect occurrences in heavily human-impacted environments
}
\details{
It uses several methods to detect records in high human influence records.\cr
Current implemented methods are: \cr
'hii' using a raster and a threhold of human influence
'urban' using a layer of urban areas. Method implemented in CoordinateCleaner package.
}
\seealso{
\link[CoordinateCleaner]{cc_urb} for CoordinateCleaner functions

Other analysis: 
\code{\link{.nearestcell3}()},
\code{\link{centroidDetection}()},
\code{\link{countryStatusRangeAnalysis}()},
\code{\link{duplicatesexcludeAnalysis}()},
\code{\link{geoEnvAccuracy}()}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr). A Zizka (CoordinateCleaner functions)
}
\concept{analysis}
\keyword{internal}
