% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\docType{class}
\name{amsr-class}
\alias{amsr-class}
\title{Class to Hold amsr Data}
\description{
The Advanced Microwave Scanning Radiometer (AMSR-2) is in current operation on
the Japan Aerospace Exploration Agency (JAXA) GCOM-W1 space craft, launched in
May 2012. Data are processed by Remote Sensing Systems. The satellite
completes an ascending and descending pass during local daytime and nightime
hours respectively. Each daily file contains 7 daytime and 7 nighttime
maps of variables named as follows within the \code{data}
slot of amsr objects: \code{timeDay}, 
\code{SSTDay}, \code{LFwindDay} (wind at 10m sensed in
the 10.7GHz band), \code{MFwindDay} (wind at 10m sensed at 18.7GHz),
\code{vaporDay}, \code{cloudDay}, and \code{rainDay}, along with
similarly-named items that end in \code{Night}.
See [1] for additional information on the instrument.
}
\details{
The bands are stored in \code{\link{raw}} form, to save storage. The accessor
function \code{\link{[[,amsr-method}} can provide these values in \code{raw}
form or in physical units; \code{\link{plot.amsr}}, and
\code{\link{summary.amsr}} work with physical units.
}
\author{
Dan Kelley and Chantelle Layton
}
\references{
1. \url{http://www.remss.com/missions/amsre}
}
\seealso{
\code{\link{landsat-class}} for handling data from the Landsat-8 satellite.

Other functions dealing with satellite data: \code{\link{[[,landsat-method}},
  \code{\link{g1sst-class}}, \code{\link{landsatAdd}},
  \code{\link{landsatTrim}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,landsat-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{read.amsr}}, \code{\link{read.g1sst}},
  \code{\link{read.landsat}},
  \code{\link{satellite-class}},
  \code{\link{summary,amsr-method}},
  \code{\link{summary,landsat-method}},
  \code{\link{summary,satellite-method}}
}
\concept{
satellite
}

