% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{ctdUpdateHeader}
\alias{ctdUpdateHeader}
\title{Update a CTD Header}
\usage{
ctdUpdateHeader(x, debug = FALSE)
}
\arguments{
\item{x}{A \code{ctd} object, i.e. one inheriting from \code{\link{ctd-class}}.}

\item{debug}{An integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}
}
\value{
A new \code{\link{ctd-class}} object.
}
\description{
Update the header of a \code{ctd} object, e.g. adjusting \code{nvalues} and the
\code{span} of each column. This is done automatically by \code{ctdTrim}, for
example.
}
\examples{
library(oce)
data(ctd) 
ctd[["pressure"]] <- ctd[["pressure"]] + 3
ctdNew <- ctdUpdateHeader(ctd)

}
\author{
Dan Kelley
}
\references{
The Seabird CTD instrument is described at
  \url{http://www.seabird.com/products/spec_sheets/19plusdata.htm}.
}
\seealso{
Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdAddColumn}}, \code{\link{ctdDecimate}},
  \code{\link{ctdFindProfiles}}, \code{\link{ctdRaw}},
  \code{\link{ctdTrim}}, \code{\link{ctd}},
  \code{\link{gps-class}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}
}

