% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{coastlineBest}
\alias{coastlineBest}
\title{Find the Name of the Best Coastline Object}
\usage{
coastlineBest(lonRange, latRange, span, debug = getOption("oceDebug"))
}
\arguments{
\item{lonRange}{range of longitude for locale}

\item{latRange}{range of latitude for locale}

\item{span}{span of domain in km (if provided, previous two arguments are
ignored).}

\item{debug}{set to a positive value to get debugging information during
processing.}
}
\value{
The name of a coastline that can be loaded with \code{data()}.
}
\description{
Find the name of the most appropriate coastline for a given locale
Checks \code{coastlineWorld}, \code{coastlineWorldFine} and
\code{coastlineWorldCoarse}, in that order, to find the one most appropriate
for the locale.
}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{coastline} data: \code{\link{[[,coastline-method}},
  \code{\link{[[<-,coastline-method}},
  \code{\link{as.coastline}},
  \code{\link{coastline-class}},
  \code{\link{coastlineCut}}, \code{\link{coastlineWorld}},
  \code{\link{download.coastline}},
  \code{\link{plot,coastline-method}},
  \code{\link{read.coastline.openstreetmap}},
  \code{\link{read.coastline.shapefile}},
  \code{\link{subset,coastline-method}},
  \code{\link{summary,coastline-method}}
}

