% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\docType{class}
\name{met-class}
\alias{met-class}
\title{Class to Store Meteorological Data}
\description{
Class to store meteorological data, with standard slots \code{metadata},
\code{data} and \code{processingLog}.  For objects created with
\code{\link{read.met}}, the \code{data} slot will contain all the columns
within the original file (with some guesses as to units) in addition to
several calculated quantities such as \code{u} and \code{v}, which are
velocities in m/s (not the km/h stored in typical data files), and which
obey the oceanographic convention that \code{u>0} is a wind towards the
east.
}
\section{Methods}{


\emph{Accessing values.} For an object named \code{m}, temperature (in degC)
may be accessed as \code{m[["temperature"]]}, dew point (in degC) as
\code{m[["dewPoint"]]}, pressure (in kPa) as \code{m[["pressure"]]},
eastward wind component (in m/s) as \code{m[["u"]]}, northward wind
component (in m/s) as \code{m[["v"]]}.  \strong{Caution:} the other elements
stored in the dataset are mainly in the format of the source file, and thus
their use requires some extra knowledge; for example,
\code{m[["direction"]]} yields the wind direction, measured in 10-degree
units positive clockwise from North.  The filename from which the data came
(if any) may be found with \code{m[["filename"]]}.  Items in \code{metadata}
must be specifield by full name, but those in \code{data} may be
abbreviated, so long as the abbreviation is unique.

\emph{Assigning values.} Everything that may be accessed may also be
assigned, e.g.
\preformatted{
m[["temperature"]] <- 1 + m[["temperature"]]
}
increases temperature by 1C.
}
\author{
Dan Kelley
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{oce-class}}, \code{\link{odf-class}},
  \code{\link{rsk-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{met} data: \code{\link{[[,met-method}},
  \code{\link{[[<-,met-method}}, \code{\link{as.met}},
  \code{\link{met}}, \code{\link{plot,met-method}},
  \code{\link{read.met}}, \code{\link{subset,met-method}},
  \code{\link{summary,met-method}}
}

