% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.sontek.R
\name{read.adp.sontek.serial}
\alias{read.adp.sontek.serial}
\title{Read a serial Sontek ADP file}
\usage{
read.adp.sontek.serial(file, from = 1, to, by = 1,
  tz = getOption("oceTz"), longitude = NA, latitude = NA,
  type = c("adp", "pcadp"), beamAngle = 25, orientation, monitor = FALSE,
  processingLog, debug = getOption("oceDebug"))
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.  (For \code{read.adp.sontek.serial}, this is generally a list of
files, which will be concatenated.}

\item{from}{indication of the first profile to read.  This can be an
integer, the sequence number of the first profile to read, or a POSIXt time
before which profiles should be skipped, or a character string that converts
to a POSIXt time (assuming UTC timezone).  See \dQuote{Examples}, and make
careful note of the use of the \code{tz} argument.}

\item{to}{if supplied, an indication of the last profile to read, in a
format as described for \code{from}.  If not supplied, the whole file will
be read.}

\item{by}{an indication of the stride length to use while walking through
the file.  If this is an integer, then \code{by-1} profiles are skipped
between each pair of profiles that is read.  If this is a string
representing a time interval, in colon-separated format (MM:SS), then this
interval is divided by the sampling interval, to get the stride length.}

\item{tz}{character string indicating time zone to be assumed in the data.}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees
North.}

\item{type}{A character string indicating the type of instrument.}

\item{beamAngle}{angle between instrument axis and beams, in degrees.}

\item{orientation}{Ooptional character string specifying the orientation of the
sensor, provided for those cases in which it cannot be inferred from the
data file.  The valid choices are \code{"upward"}, \code{"downward"}, and
\code{"sideward"}.}

\item{monitor}{boolean, set to \code{TRUE} to provide an indication (with
numbers and dots) of every profile read.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{\dots}{additional arguments, passed to called routines.}
}
\value{
An \code{adp} object, i.e. one inheriting from \code{\link{adp-class}}.
}
\description{
Read a Sontek acoustic-Dopplerprofiler file, in a serial form that
is possibly unique to Dalhousie University.
}
\author{
Dan Kelley and Clark Richards
}
\seealso{
Other things related to \code{adp} data: \code{\link{[[,adp-method}},
  \code{\link{[[<-,adp-method}}, \code{\link{adp-class}},
  \code{\link{adp}}, \code{\link{as.adp}},
  \code{\link{beamName}}, \code{\link{beamToXyzAdp}},
  \code{\link{beamToXyzAdv}}, \code{\link{beamToXyz}},
  \code{\link{beamUnspreadAdp}}, \code{\link{binmapAdp}},
  \code{\link{enuToOtherAdp}}, \code{\link{enuToOther}},
  \code{\link{plot,adp-method}},
  \code{\link{read.adp.nortek}},
  \code{\link{read.adp.rdi}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}},
  \code{\link{subset,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdp}}, \code{\link{xyzToEnu}}
}

