% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\docType{methods}
\name{subset,topo-method}
\alias{subset,topo-method}
\title{Subset a Topo Object}
\usage{
\S4method{subset}{topo}(x, subset, ...)
}
\arguments{
\item{x}{A \code{topo} object, i.e. inheriting from \code{\link{topo-class}}.}

\item{subset}{A condition to be applied to the \code{data} portion of \code{x}.
See \sQuote{Details}.}

\item{...}{Ignored.}
}
\value{
A new \code{\link{topo-class}} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
Subsetting can be by \code{time} or \code{distance}, but these may not be
combined; use a sequence of calls to subset by both.
}
\examples{
## northern hemisphere
library(oce)
data(topoWorld)
plot(subset(topoWorld, latitude > 0))

}
\seealso{
Other things related to \code{topo} data: \code{\link{[[,topo-method}},
  \code{\link{[[<-,topo-method}}, \code{\link{as.topo}},
  \code{\link{download.topo}},
  \code{\link{plot,topo-method}}, \code{\link{read.topo}},
  \code{\link{summary,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoInterpolate}},
  \code{\link{topoWorld}}
}
\author{
Dan Kelley
}
