% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapText}
\alias{mapText}
\title{Add Text to a Map}
\usage{
mapText(longitude, latitude, labels, ...)
}
\arguments{
\item{longitude}{vector of longitudes of text to be plotted.}

\item{latitude}{vector of latitudes of text to be plotted.}

\item{labels}{vector of labels of text to be plotted.}

\item{...}{optional arguments passed to \code{\link{text}}, e.g. \code{adj},
\code{pos}, etc.}
}
\description{
Plot text on an existing map.
}
\details{
Adds text to an existing map, by analogy to \code{\link{text}}.
}
\examples{
\dontrun{
library(oce)
data(coastlineWorld)
longitude <- coastlineWorld[['longitude']]
latitude <- coastlineWorld[['latitude']]
mapPlot(longitude, latitude, type='l', grid=5,
        longitudelim=c(-70,-50), latitudelim=c(45, 50),
        projection="+proj=merc")
lon <- -63.5744 # Halifax
lat <- 44.6479
mapPoints(lon, lat, pch=20, col="red")
mapText(lon, lat, "Halifax", col="red", pos=1, offset=1)
}
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapScalebar}},
  \code{\link{mapTissot}}, \code{\link{oceCRS}},
  \code{\link{shiftLongitude}}, \code{\link{usrLonLat}},
  \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
