library(oce)
context("landsat")
test_that("landsatTrim", {
          data(landsat)
          lt <- landsatTrim(landsat,list(longitude=-64,latitude=44),list(longitude=-63,latitude=45))
          expect_equal(dim(lt[["aerosol"]]), c(27,38))
          expect_equal(dim(lt[["blue"]]), c(27,38))
          expect_equal(dim(lt[["green"]]), c(27,38))
          expect_equal(dim(lt[["red"]]), c(27,38))
          expect_equal(dim(lt[["nir"]]), c(27,38))
          expect_equal(dim(lt[["swir1"]]), c(27,38))
          expect_equal(dim(lt[["swir2"]]), c(27,38))
          expect_equal(dim(lt[["panchromatic"]]), c(55,74))
          expect_equal(dim(lt[["cirrus"]]), c(27,38))
          expect_equal(dim(lt[["tirs1"]]), c(27,38))
          expect_equal(dim(lt[["tirs2"]]), c(27,38))
          expect_equal(lt[["lllat"]], 44)
          expect_equal(lt[["urlat"]], 45)
          expect_equal(lt[["lllon"]], -64)
          expect_equal(lt[["urlon"]], -63)
          expect_equal(c(27, 38), dim(lt[["tirs1"]]))
})


