% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\docType{class}
\name{tidem-class}
\alias{tidem-class}
\title{Class to Store Tidal Models}
\description{
This class stores tidal-constituent models.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{tidem} objects is a
\code{\link{list}} containing the main data for the object.
{}}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{tidem} objects is a \code{\link{list}} containing
information about the \code{data} or about the object itself.
{}}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{tidem} objects is a
\code{\link{list}} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link{processingLogShow}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \code{tidem} objects (see \code{\link{[[<-,tidem-method}}),
it is better to use \code{\link{oceSetData}}
and \code{\link{oceSetMetadata}}, because that will save an entry
in the \code{processingLog} to describe the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \code{tidem}
object named \code{tidem} may be retrieved in the standard R way. For example,
\code{slot(tidem, "data")} and \code{slot(tidem, "metadata")} return
the \code{data} and \code{metadata} slots, respectively. The
\code{\link{[[,tidem-method}} operator can also be used to access slots,
with \code{tidem[["data"]]} and \code{tidem[["metadata"]]}, respectively.
Furthermore, \code{\link{[[,tidem-method}} can be used to retrieve
named items (and potentially some derived items) within the
\code{metadata} and \code{data} slots, the former taking precedence
over the latter in the lookup. It is also possible
to find items more directly, using \code{\link{oceGetData}} and
\code{\link{oceGetMetadata}}, but this cannot retrieve derived items.
}

\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,landsat-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}

Other things related to \code{tidem} data: \code{\link{[[,tidem-method}},
  \code{\link{[[<-,tidem-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{predict.tidem}},
  \code{\link{summary,tidem-method}},
  \code{\link{tidedata}}, \code{\link{tidemAstron}},
  \code{\link{tidemVuf}}, \code{\link{tidem}}
}
\author{
Dan Kelley
}
\concept{functions that plot \code{oce} data}
\concept{things related to \code{tidem} data}
