% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{addSpine}
\alias{addSpine}
\title{Add a spine to a section object}
\usage{
addSpine(section, spine, debug = getOption("oceDebug"))
}
\arguments{
\item{section}{a \linkS4class{section} object.}

\item{spine}{either a list or a data frame, containing numeric items named
\code{longitude} and \code{latitude}, defining a path along the spine.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A \linkS4class{section} object with a spine added.
}
\description{
The purpose of this is to permit plotting with \code{xtype="spine"}, so that
the section plot will display the distance of stations projected
onto the spine.
}
\examples{
library(oce)
data(section)
sectionWest <- subset(section, longitude < -60)
spine <- list(longitude=c(-74.5, -69.2, -55), latitude=c(38.6, 36.25, 36.25))
sectionWithSpine <- addSpine(sectionWest, spine)
plot(sectionWithSpine, which="map")
plot(sectionWithSpine, xtype="distance", which="temperature")
plot(sectionWithSpine, xtype="spine", which="temperature")

}
\author{
Dan Kelley
}
