% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{as.coastline}
\alias{as.coastline}
\title{Coerce Data into a Coastline Object}
\usage{
as.coastline(longitude, latitude, fillable = FALSE)
}
\arguments{
\item{longitude}{the longitude in decimal degrees, positive east of
Greenwich, or a data frame with columns named \code{latitude} and
\code{longitude}, in which case these values are extracted from the data
frame and the second argument is ignored.}

\item{latitude}{the latitude in decimal degrees, positive north of the
Equator.}

\item{fillable}{boolean indicating whether the coastline can be drawn as a
filled polygon.}
}
\value{
a \linkS4class{coastline} object.
}
\description{
Coerces a sequence of longitudes and latitudes into a coastline dataset.
This may be used when \code{\link[=read.coastline]{read.coastline()}} cannot read a file, or
when the data have been manipulated.
}
\seealso{
Other things related to coastline data: 
\code{\link{[[,coastline-method}},
\code{\link{[[<-,coastline-method}},
\code{\link{coastline-class}},
\code{\link{coastlineBest}()},
\code{\link{coastlineCut}()},
\code{\link{coastlineWorld}},
\code{\link{download.coastline}()},
\code{\link{plot,coastline-method}},
\code{\link{read.coastline.openstreetmap}()},
\code{\link{read.coastline.shapefile}()},
\code{\link{subset,coastline-method}},
\code{\link{summary,coastline-method}}
}
\author{
Dan Kelley
}
\concept{things related to coastline data}
