% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\docType{data}
\name{tidalCurrent}
\alias{tidalCurrent}
\title{Tidal Current Dataset}
\source{
The data come from the \code{tide8.dat} and \code{tide9.dat} files provided
at reference 2.
}
\description{
The \code{tidalCurrent} dataset contains tidal velocities reported in
Foreman's (1978) report (reference 1) on his Fortran code for the analysis of
tidal currents and provided in an associated webpage (reference 2).
Here, \code{tidalCurrent} is data frame containing
\itemize{
\item \code{time} a POSIXct time.
\item \code{u} the eastward component of velocity in m/s.
\item \code{v} the northward component of velocity in m/s.
}
}
\examples{
library(oce)
data(tidalCurrent)
par(mfrow=c(2, 1))
oce.plot.ts(tidalCurrent$time, tidalCurrent$u, ylab="u [m/s]")
abline(h=0, col=2)
oce.plot.ts(tidalCurrent$time, tidalCurrent$v, ylab="v [m/s]")
abline(h=0, col=2)

}
\references{
\enumerate{
\item Foreman, M. G. G. "Manual for Tidal Currents Analysis and Prediction."
Pacific Marine Science Report.
British Columbia, Canada: Institute of Ocean Sciences, Patricia Bay, 1978.
\item \code{https://www.dfo-mpo.gc.ca/science/documents/data-donnees/tidal-marees/tidpack.zip}
}
}
\seealso{
Other things related to tides: 
\code{\link{[[,tidem-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{as.tidem}()},
\code{\link{plot,tidem-method}},
\code{\link{predict.tidem}()},
\code{\link{summary,tidem-method}},
\code{\link{tidedata}},
\code{\link{tidem-class}},
\code{\link{tidemAstron}()},
\code{\link{tidemVuf}()},
\code{\link{tidem}},
\code{\link{webtide}()}
}
\author{
Dan Kelley (reformatting data provided by Michael Foreman)
}
\concept{things related to tides}
