% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.ssda.R
\name{read.ctd.ssda}
\alias{read.ctd.ssda}
\title{Read CTD format in SSDA format}
\usage{
read.ctd.ssda(
  file,
  encoding = "latin1",
  debug = getOption("oceDebug"),
  processingLog
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. If nonzero, some information
is printed.}

\item{processingLog}{ignored.}
}
\value{
\code{\link[=read.ctd.ssda]{read.ctd.ssda()}} returns a \linkS4class{ctd} object.
}
\description{
\code{\link[=read.ctd.ssda]{read.ctd.ssda()}} reads CTD files in Sea & Sun Technology´s Standard Data
Acquisition (SSDA) format. This function is somewhat preliminary, in the
sense that header information is not scanned fully, and some guesses have
been made about the meanings of variables and units.
}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}

Other functions that read ctd data: 
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()}
}
\author{
Dan Kelley, with help from Liam MacNeil
}
\concept{functions that read ctd data}
\concept{things related to ctd data}
