% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{initializeFlags}
\alias{initializeFlags}
\title{Create and Initialize oce Flags}
\usage{
initializeFlags(object, name = NULL, value = NULL, debug = 0)
}
\arguments{
\item{object}{An \linkS4class{oce} object.}

\item{name}{Character value indicating the name of a variable within the
\code{data} slot of \code{object}.}

\item{value}{Numerical or character value to be stored in the newly-created
entry within \code{flags}. (A character value will only work if
\code{\link[=initializeFlags]{initializeFlags()}} has been used first on \code{object}.)}

\item{debug}{Integer set to 0 for quiet action or to 1 for some debugging.}
}
\value{
An object with the \code{flags} item within the
\code{metadata} slot set up as indicated.
}
\description{
This function creates an item for a named variable within
the \code{flags} entry in the object's \code{metadata} slot.
The purpose is both to document a flag scheme
and to make it so that \code{\link[=initializeFlags]{initializeFlags()}}
and \code{\link[=setFlags]{setFlags()}} can specify flags by
name, in addition to number. A generic function, it is
specialized for some classes via interpretation of the
\code{scheme} argument (see \dQuote{Details}, for those
object classes that have such specializations).
}
\details{
If \code{object} already contains a \code{flags} entry with
the indicated name, then it is returned unaltered, and a warning
is issued.
}
\seealso{
Other functions relating to data-quality flags: 
\code{\link{defaultFlags}()},
\code{\link{handleFlags,adp-method}},
\code{\link{handleFlags,argo-method}},
\code{\link{handleFlags,ctd-method}},
\code{\link{handleFlags,oce-method}},
\code{\link{handleFlags,section-method}},
\code{\link{handleFlags}()},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{initializeFlagScheme,oce-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{initializeFlagSchemeInternal}()},
\code{\link{initializeFlagScheme}()},
\code{\link{initializeFlags,adp-method}},
\code{\link{initializeFlags,oce-method}},
\code{\link{initializeFlagsInternal}()},
\code{\link{setFlags,adp-method}},
\code{\link{setFlags,ctd-method}},
\code{\link{setFlags,oce-method}},
\code{\link{setFlags}()}
}
\concept{functions relating to data-quality flags}
