% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redfieldNP.R
\docType{data}
\name{redfieldNP}
\alias{redfieldNP}
\title{Redfield's (1934) NO3 and PO4 data}
\usage{
data(redfieldNP, package="ocedata")
}
\description{
Data digitized from Redfield's (1934) Figure 1, showing
\eqn{\textrm{NO}_3}{NO3} dependence on \eqn{\textrm{PO}_4}{PO4}.  This
dataset is used in Chapter 4 of Kelley (2018).
}
\examples{
data(redfieldNP, package="ocedata")
plot(redfieldNP$PO4, redfieldNP$NO3,
    xlab=expression(PO[4]), ylab=expression(NO[3]))
abline(0, 20, lwd=3)  # slope N:P = 20:1, shown by Redfield

}
\references{
\enumerate{
\item Kelley, Dan E. Oceanographic Analysis with R. 1st ed. 2018. New York, NY:
Springer New York: Imprint: Springer, 2018. \doi{10.1007/978-1-4939-8844-0}.
\item Alfred C. Redfield, 1934.  On the proportions of organic derivations in
sea water and their relation to the composition of plankton.  Pages 177--192
in James Johnstone Memorial Volume, University Press of Liverpool.
}
}
\seealso{
Other data related to Redfield (1934): 
\code{\link{redfieldNC}},
\code{\link{redfieldPlankton}}
}
\concept{data related to Redfield (1934)}
