% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfunctions.R
\name{MixBetaDens}
\alias{MixBetaDens}
\title{Mixture of Beta Functions}
\usage{
MixBetaDens(n, p, x = seq(0, 15, by = 0.01), a = 0, b = 1,
  n_g = n_g, var = var)
}
\arguments{
\item{n}{The number of observations in the dataset}

\item{p}{The dimension}

\item{x}{A vector of x values to evaluate. Default value is seq(0, 15, by=0.01)}

\item{a}{Lower bound for area evaluation. Default value is 0}

\item{b}{Upper bound for area evaluation. Default value is 1}

\item{n_g}{Vector decribing the number of observations in each cluster}

\item{var}{An array of variances, one slice for each cluster}
}
\value{
MixBetaDens returns a list with
\item{ pdf }{The probability density at each x value}
\item{ cdf }{The cumulative density at each x value}
\item{ area }{The area under the pdf graph between a and b}
}
\description{
MixBetaDens generates the pdf and cdf of a mixture of beta functions, and calculates the area under the graph between two points.
}
\details{
The domain for this function is not [0,1] as is typical with a beta function. The domain encompasses the shifted log-likelihoods generated in \code{\link{oclust}}.
}
