\name{draw.octopucs}
\alias{draw.octopucs}
\title{
Draw the Generalized Clustering Hypothesis
}
\description{
Draws the resulting generalized cluster with tips facing either 
down, left or right.
}
\usage{
draw.octopucs(M2, cex=1, lab.pos=0.09, n=NULL,
distance=NULL, method=NULL, prop=NULL, Name=NULL, ylim=NULL, xlim=NULL,
verbose=NULL, orientation=NULL, support=NULL, sep.lab=NULL, disp = NULL)
}
\arguments{
  \item{M2}{
A lis object generated by glzcluster or glzcluster2
}
  \item{cex}{
Size of text in the figure
}
  \item{lab.pos}{
This argument modifies the position of the labels relative to the tips of
the dendrogram (sites/conditions).
}
  \item{n}{
This is defined in the glzcluster or glzcluster2 functions.
Number of bootstrap samples performed.
}
  \item{distance}{
Distance method used (default="bray").
This is defined in the glzcluster or glzcluster2 functions.
Options include those of the function "vegdist" ("vegan"): "manhattan", 
"euclidean", "canberra", "bray", "kulczynski", "gower", "morisita", "horn", 
"mountford", "jaccard", "raup", "binomial", "chao", "altGower", "cao" and 
"mahalanobis", as well as those referred in Koleff et al. (2003), available 
either by name or number: 1 or "w", 2 or "-1", 3 or "c", 4 or "wb", 5 or "r", 
6 or "I", 7 or "e", 8 or "t", 9 or "me", 10 or "j", 11 or "sor", 12 or "m", 13 
or "-2", 14 or "co", 15 or "cc", 16 or "g", 17 or "-3", 18 or "1", 19 or "", 20 
or "hk", 21 or "rlb", 22 or "sim", 23 or "gl", 24 or "z". For open distance 
metrics (not restricted to zero-one ranges), the axis is re-scaled to cover a 
zero-one range. If so, the axis will be labeled a "Similarity (rescaled)"; 
if no re-scaling is necessary, the label will appear as "Similarity".
}
  \item{method}{
This is defined in the glzcluster or glzcluster2 functions.
Agglomerative procedure for hierarchical clustering, including: 
"average" (=UPGMA), "ward.D", "ward.D2", "single", "complete", 
"mcquitty" (=WPGMA), "median" (=WPGMC) or "centroid" (=UPGMC).
}
  \item{prop}{
This is defined in the glzcluster or glzcluster2 functions.
Proportion of information used in the bootstrapping procedures. When matrices 
contain more than 18 columns, it refers to: (i) the proportion of columns used 
in every run to produce a new grouping array when "resample=TRUE" and (ii) the 
amount of cells in the body of the matrix (1–prop; e.g., 1–0.8=0.2) that will 
be replaced with column averages when "resample=FALSE". When matrices contain 
less than 18 columns, the procedure with "resample=FALSE" will be forced. In 
such scenario, "prop" corresponds to the amount of cells in the body of the 
matrix (1–prop; e.g., 1–0.8=0.2) that will be replaced in the bootstrapping 
procedures.
}
  \item{Name}{
Name of the database run on octopucs
}

  \item{xlim}{
Limits of the x-axis
}
  \item{ylim}{
Limits of the y-axis
}
  \item{verbose}{
TRUE = display all relevant setup values used in the analysis. FALSE = display 
only the dendrogram with marked significantly grouped clusters.
}
  \item{orientation}{
Any of d, l, or r denoting the orientation of the tips (down, left, and right, 
respectively)
}

  \item{support}{
A matrix object generated by the function glzcs
}
  \item{sep.lab}{
This argument modifies the position of supporting values from the nodes and
lines and the dendrogram.
}
  \item{disp}{
What to display in relation to supporting values for the groups and subgroups. 
By default is set to "sig" and then support values are shown only in those 
groups statistically supported.
}
}

\value{
This function draws and if requested, populate with support metrics the consesnsus hypothesis of clustering
}

\references{
Koleff, P., Gaston, K.J., Lennon, J. J. 2003. Measuring beta diversity for 
presence–absence data. Journal of Animal Ecology 71:367.
https://doi.org/10.1046/j.1365-2656.2003.00710.x
}
\author{
Roger Guevara (roger.guevara@inecol.mx) & 
Ian MacGregor-Fors (ian.macgregor@helsinki.fi)
}

\examples{
data(dune)
rownames(dune)<- paste("S",1:20, sep="")
OCT <- glzcluster(dune, n=100)
GRP <- IDscluster(OCT)
SUP <- glzcs(GRP, OCT)
draw.octopucs(OCT, support=SUP)
}
