% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver-snowflake.R
\docType{class}
\name{snowflake}
\alias{snowflake}
\alias{SnowflakeOdbcDriver-class}
\alias{dbConnect,SnowflakeOdbcDriver-method}
\title{Helper for connecting to Snowflake via ODBC}
\usage{
snowflake()

\S4method{dbConnect}{SnowflakeOdbcDriver}(
  drv,
  account = Sys.getenv("SNOWFLAKE_ACCOUNT"),
  driver = NULL,
  warehouse = NULL,
  database = NULL,
  schema = NULL,
  uid = NULL,
  pwd = NULL,
  ...
)
}
\arguments{
\item{drv}{An object that inherits from \link[DBI:DBIDriver-class]{DBI::DBIDriver},
or an existing \link[DBI:DBIConnection-class]{DBI::DBIConnection}
object (in order to clone an existing connection).}

\item{account}{A Snowflake \href{https://docs.snowflake.com/en/user-guide/admin-account-identifier}{account identifier},
e.g. \code{"testorg-test_account"}.}

\item{driver}{The name of the Snowflake ODBC driver, or \code{NULL} to use the
default name.}

\item{warehouse}{The name of a Snowflake compute warehouse, or \code{NULL} to use
the default.}

\item{database}{The name of a Snowflake database, or \code{NULL} to use the
default.}

\item{schema}{The name of a Snowflake database schema, or \code{NULL} to use the
default.}

\item{uid, pwd}{Manually specify a username and password for authentication.
Specifying these options will disable ambient credential discovery.}

\item{...}{Further arguments passed on to \code{\link[=dbConnect]{dbConnect()}}.}
}
\value{
An \code{OdbcConnection} object with an active connection to a Snowflake
account.
}
\description{
Connect to a Snowflake account via the \href{https://docs.snowflake.com/en/developer-guide/odbc/odbc}{Snowflake ODBC driver}.

In particular, the custom \code{dbConnect()} method for the Snowflake ODBC driver
detects ambient OAuth credentials on platforms like Snowpark Container
Services or Posit Workbench. It can also detect viewer-based
credentials on Posit Connect if the \pkg{connectcreds} package is
installed.

In addition, on macOS platforms, the \code{dbConnect} method will check and warn
if it detects irregularities with how the driver is configured, unless the
\code{odbc.no_config_override} environment variable is set.
}
\examples{
\dontrun{
# Use ambient credentials.
DBI::dbConnect(odbc::snowflake())

# Use browser-based SSO (if configured). Only works on desktop.
DBI::dbConnect(
  odbc::snowflake(),
  account = "testorg-test_account",
  authenticator = "externalbrowser"
)

# Use a traditional username & password.
DBI::dbConnect(
  odbc::snowflake(),
  account = "testorg-test_account",
  uid = "me",
  pwd = rstudioapi::askForPassword()
)

# Use credentials from the viewer (when possible) in a Shiny app
# deployed to Posit Connect.
library(connectcreds)
server <- function(input, output, session) {
  conn <- DBI::dbConnect(odbc::snowflake())
}
}
}
