% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.oddsratio.into.plot.R
\name{add.oddsratio.into.plot}
\alias{add.oddsratio.into.plot}
\title{Insert odds ratios of GAM(M)s into smoothing function}
\usage{
add.oddsratio.into.plot(plot.object, or.object, line.col = "red",
  line.size = 1.2, line.type = "solid", line.alpha = 1, text.alpha = 1,
  text.size = 4, text.col = "black", rect.alpha = 0.5, rect.col = NULL,
  rect = FALSE, arrow = TRUE, values = TRUE, values.yloc = 0,
  values.xloc = NULL, or.yloc = 0, arrow.length = NULL,
  arrow.yloc = NULL, arrow.col = NULL, arrow.xloc.r = NULL,
  arrow.xloc.l = NULL)
}
\arguments{
\item{plot.object}{A `ggplot` object from \code{\link[oddsratio]{pl.smooth.gam}}}

\item{or.object}{A returned data.frame from \code{\link[oddsratio]{calc.oddsratio.gam}}}

\item{line.col, line.alpha, line.type, line.size}{Aesthetics of vertical lines.}

\item{text.col, text.alpha, text.size}{Aesthetics of inserted values.}

\item{rect.col, rect.alpha}{Aesthetics of shaded rectangle.}

\item{rect}{Logical. Whether to print a shaded rectangle between the vertical lines.}

\item{arrow}{Logical. Wheter to print arrows above the inserted values. Default to \code{TRUE}.}

\item{values}{Logical. Whether to print predictor value information nearby 
the inserted vertical lines. Default to \code{TRUE}.}

\item{values.xloc}{Numeric. X-axis location/shift of values relative to their vertical line.
Default to 2\% of x-axis range.}

\item{or.yloc, values.yloc}{Numeric. Specifies y-location of inserted odds ratio / values.
Relative to plotted y-axis range. A positive/negative value will place the 
the text higher/lower.}

\item{arrow.xloc.r, arrow.xloc.l, arrow.yloc, arrow.length, arrow.col}{Numeric. Axis placement options of inserted arrows.
Relative to respective axis ranges.}
}
\value{
Returns a \code{ggplot} plotting object
}
\description{
This function inserts calculated odds ratios of GAM(M)s into a plot of a
GAM(M) smoothing function.
}
\details{
The idea behind this function is to add calculated odds ratio of 
fitted GAM models (\code{\link[oddsratio]{calc.oddsratio.gam}}) into a plot 
showing the smooth function (\code{\link[oddsratio]{pl.smooth.gam}}) of the chosen 
predictor for which the odds ratio was calculated for. Multiple insertions can 
be made by iteratively calling the function (see examples).

Right now the function does only accept results of 
\code{\link[oddsratio]{calc.oddsratio.gam}} with \code{slice = FALSE}. 
If you want to insert multiple odds ratio you have to do it iteratively.
}
\examples{
# load data (Source: ?mgcv::gam) and fit model
library(mgcv)
fit.gam <- gam(y ~ s(x0) + s(I(x1^2)) + s(x2) + 
               offset(x3) + x4, data = data.gam) # fit model
               
# create input objects (plot + odds ratios)   
library(oddsratio)            
plot.object <- pl.smooth.gam(fit.gam, pred = "x2", title = "Predictor 'x2'")
or.object1 <- calc.oddsratio.gam(data = data.gam, model = fit.gam, pred = "x2", 
                                 values = c(0.099, 0.198))
                               
# insert first odds ratios to plot
plot.object <- add.oddsratio.into.plot(plot.object, or.object1, or.yloc = 3,
                                       values.xloc = 0.04, line.size = 0.5, 
                                       line.type = "dotdash", text.size = 6,
                                       values.yloc = 0.5, arrow.col = "red")

# calculate second odds ratio
or.object2 <- calc.oddsratio.gam(data = data.gam, model = fit.gam, pred = "x2", 
                                 values = c(0.4, 0.6))
                                  
# add or.object2 into plot                                  
add.oddsratio.into.plot(plot.object, or.object2, or.yloc = 2.1, values.yloc = 2,
                        line.col = "green4", text.col = "black",
                        rect.col = "green4", rect.alpha = 0.2,
                        line.alpha = 1, line.type = "dashed",
                        arrow.xloc.r = 0.01, arrow.xloc.l = -0.01,
                        arrow.length = 0.01, rect = TRUE)          
}
\author{
Patrick Schratz <patrick.schratz@gmail.com>
}
\seealso{
\code{\link[oddsratio]{pl.smooth.gam}}

\code{\link[oddsratio]{calc.oddsratio.gam}}
}

