% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpe.R
\name{rpe}
\alias{rpe}
\title{Relative precision and efficiency (RPE) calculation}
\usage{
rpe(od, subod, rounded = TRUE, verbose = TRUE)
}
\arguments{
\item{od}{returned object of first design (e.g., unconstrained optimal design)
from function \code{\link{od.1}}, \code{\link{od.2}},
\code{\link{od.3}}, \code{\link{od.4}}, \code{\link{od.2m}},
\code{\link{od.3m}}, or \code{\link{od.4m}}}

\item{subod}{returned object of second design (e.g., constrained optimal design)
from function \code{\link{od.1}}, \code{\link{od.2}},
\code{\link{od.3}}, \code{\link{od.4}}, \code{\link{od.2m}},
\code{\link{od.3m}}, or \code{\link{od.4m}}}

\item{rounded}{logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions to two decimal places and integer, respectively if TRUE,
no rounding if FALSE; default is TRUE.}

\item{verbose}{logical; print the value of relative precision and efficiency if TRUE,
otherwise not; default is TRUE.}
}
\value{
Relative precision and efficiency value.
}
\description{
Calculate the relative precision and efficiency (RPE) between two designs,
    it returns same results as those from function \code{\link{re}}
}
\examples{
# unconstrained optimal design of 2-level CRT #----------
  myod1 <- od.2(icc = 0.2, r12 = 0.5, r22 = 0.5, c1 = 1, c2 = 5, c1t = 1, c2t = 50,
              varlim = c(0.01, 0.02))
# constrained optimal design with n = 20
  myod2 <- od.2(icc = 0.2, r12 = 0.5, r22 = 0.5, c1 = 1, c2 = 5, c1t = 1, c2t = 50,
              n = 20, varlim = c(0.005, 0.025))
# relative precision and efficiency (RPE)
  myrpe <- rpe(od = myod1, subod= myod2)
  myrpe$out # RPE = 0.88
# constrained optimal design with p = 0.5
  myod2 <- od.2(icc = 0.2, r12 = 0.5, r22 = 0.5, c1 = 1, c2 = 5, c1t = 1, c2t = 50,
             p = 0.5, varlim = c(0.005, 0.025))
# relative precision and efficiency (RPE)
  mypre <- rpe(od = myod1, subod= myod2)
  mypre$out # RPE = 0.90

# unconstrained optimal design of 3-level CRT #----------
  myod1 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0.005, 0.025))
# constrained optimal design with J = 20
  myod2 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5, J = 20,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0, 0.025))
# relative precision and efficiency (RPE)
  myrpe <- rpe(od = myod1, subod= myod2)
  myrpe$out # RPE = 0.53

# unconstrained optimal design of 4-level CRT #---------
  myod1 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05, r12 = 0.5,
              r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01))
# constrained optimal design with p = 0.5
  myod2 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05, r12 = 0.5, p = 0.5,
              r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01))
# relative precision and efficiency (RPE)
  myrpe <- rpe(od = myod1, subod= myod2)
  myrpe$out # RPE = 0.78

}
\references{
Shen, Z., & Kelcey, B. (2018, April). Optimal design of cluster
  randomized trials under condition- and unit-specific cost structures. Roundtable
  discussion presented at American Educational Research Association (AERA)
  annual conference, New York City, NY;

  Shen, Z., & Kelcey, B. (revise & resubmit).
  Optimal sample allocation under unequal costs in cluster-randomized trials.
  Journal of Educational and Behavioral Statistics.

  Shen, Z. (in progress).
  Using optimal sample allocation to
  improve statistical precision and design efficiency for multilevel randomized trials
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
