% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.4.R
\name{od.4}
\alias{od.4}
\title{Optimal sample allocation calculation for four-level CRTs}
\usage{
od.4(n = NULL, J = NULL, K = NULL, p = NULL, icc2 = NULL,
  icc3 = NULL, icc4 = NULL, r12 = NULL, r22 = NULL, r32 = NULL,
  r42 = NULL, c1 = NULL, c2 = NULL, c3 = NULL, c4 = NULL,
  c1t = NULL, c2t = NULL, c3t = NULL, c4t = NULL, m = NULL,
  plots = TRUE, plot.by = NULL, nlim = NULL, Jlim = NULL,
  Klim = NULL, plim = NULL, varlim = NULL, nlab = NULL,
  Jlab = NULL, Klab = NULL, plab = NULL, varlab = NULL,
  vartitle = NULL, verbose = TRUE, iter = 100, tol = 1e-10)
}
\arguments{
\item{n}{the level-1 sample size per level-2 unit.}

\item{J}{the level-2 sample size per level-3 unit.}

\item{K}{the level-3 sample size per level-4 unit.}

\item{p}{the proportion of level-4 clusters/units to be assigned to treatment.}

\item{icc2}{the unconditional intraclass correlation coefficient (ICC) at level 2.}

\item{icc3}{the unconditional intraclass correlation coefficient (ICC) at level 3.}

\item{icc4}{the unconditional intraclass correlation coefficient (ICC) at level 4.}

\item{r12}{the proportion of level-1 variance explained by covariates.}

\item{r22}{the proportion of level-2 variance explained by covariates.}

\item{r32}{the proportion of level-3 variance explained by covariates.}

\item{r42}{the proportion of level-4 variance explained by covariates.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit in control condition.}

\item{c3}{the cost of sampling one level-3 unit in control condition.}

\item{c4}{the cost of sampling one level-4 unit in control condition.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{the cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{the cost of sampling one level-3 unit in treatment condition.}

\item{c4t}{the cost of sampling one level-4 unit in treatment condition.}

\item{m}{total budget, default value is the total costs of sampling 60
level-4 units across treatment conditions.}

\item{plots}{logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plot.by}{specify variance plot by \code{n}, \code{J}, \code{K} and/or \code{p};
default value is plot.by = list(n = "n", J = "J", K = 'K', p = "p").}

\item{nlim}{the plot range for n, default value is c(2, 50).}

\item{Jlim}{the plot range for J, default value is c(2, 50).}

\item{Klim}{the plot range for K, default value is c(2, 50).}

\item{plim}{the plot range for p, default value is c(0, 1).}

\item{varlim}{the plot range for variance, default value is c(0, 0.05).}

\item{nlab}{the plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{Jlab}{the plot label for \code{J},
default value is "Level-2 Sample Size: J".}

\item{Klab}{the plot label for \code{K},
default value is "Level-3 Sample Size: K".}

\item{plab}{the plot label for \code{p},
default value is "Proportion Level-4 Units in Treatment: p".}

\item{varlab}{the plot label for variance,
default value is "Variance".}

\item{vartitle}{the title of variance plot, default value is NULL.}

\item{verbose}{logical; print the values of \code{n}, \code{J},
\code{K}, and \code{p} if TRUE,
otherwise not; default value is TRUE.}

\item{iter}{number of iterations; default value is 100.}

\item{tol}{tolerance for convergence; default value is 1e-10.}
}
\value{
unconstrained or constrained optimal sample allocation
    (\code{n}, \code{J}, \code{K}, and \code{p}).
    The function also returns the variance of treatment effect,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of four-level
    cluster randomized trials (CRTs) is to choose
    the sample allocation that minimizes the variance of
    treatment effect under fixed budget and cost structure.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n}),
    the level-2 sample size per level-3 unit (\code{J}),
    the level-3 sample size per level-4 unit (\code{K}),
    and the proportion of level-4 clusters/groups to be assigned to treatment (\code{p}).
    This function solves the optimal \code{n}, \code{J}, \code{K} and/or \code{p}
    with and without constraints.
}
\examples{
# unconstrained optimal design #---------
  myod1 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01))
  myod1$out # output
# plots by p and K
  myod1 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01), plot.by = list(p = 'p', K = 'K'))

# constrained optimal design with p = 0.5 #---------
  myod2 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05, p = 0.5,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01))
  myod2$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.78

# constrained optimal design with K = 20 #---------
  myod3 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,  K = 20,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01))
  myod3$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod3)
  myre$re # RE = 0.67

# constrained n, J, K and p, no calculation performed #---------
  myod4 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
              r12 = 0.5, n = 10, J = 10, K = 20, p = 0.5,
              r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
              varlim = c(0, 0.01))
  myod4$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod4)
  myre$re # RE = 0.27

}
\references{
Shen, Z. (in progress). Using optimal sample allocation to
  improve statistical precision and design efficiency for multilevel randomized trials
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
