% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.call_timed.R
\name{do.call_timed}
\alias{do.call_timed}
\title{Measure computation time}
\usage{
do.call_timed(what, args, units = "secs")
}
\arguments{
\item{what, args}{Passed to \code{\link[base]{do.call}}.}

\item{units}{Passed to \code{\link[base]{difftime}}.}
}
\value{
A list of the two elements \code{"result"} (the results of the \code{do.call}
call) and \code{"time"} (the computation time).
}
\description{
This function measures the computation time of a call.
}
\details{
This function is a wrapper for \code{\link[base]{do.call}}.
}
\examples{
\dontrun{
what <- function(s) {
  Sys.sleep(s)
  return(s)
}
args <- list(s = 1)
do.call_timed(what = what, args = args)
}
}
\seealso{
Other function helpers: 
\code{\link{function_arguments}()},
\code{\link{function_body}()},
\code{\link{function_defaults}()},
\code{\link{quiet}()},
\code{\link{timed}()},
\code{\link{try_silent}()},
\code{\link{variable_name}()}
}
\concept{function helpers}
\keyword{simulation}
