% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_namespace_calls.R
\name{find_namespace_calls}
\alias{find_namespace_calls}
\title{Namespace calls}
\usage{
find_namespace_calls(path = "R", triple_colon = FALSE, as_list = FALSE)
}
\arguments{
\item{path}{[\code{character(1)}]\cr
The path name to a folder. All \code{.R} files in this folder and sub-directories
will be searched.}

\item{triple_colon}{[\code{logical(1)}]\cr
Also search for \code{:::}?}

\item{as_list}{[\code{logical(1)}]\cr
Simplify the output into a \code{list} of unique function names per package?}
}
\value{
A \code{data.frame}. If \code{as_list = TRUE}, a \code{list}.
}
\description{
This function searches for namespace calls in \code{.R} files, i.e., code lines of
the format \verb{<package name>::<function name>}.
}
\examples{
\dontrun{
find_namespace_calls()
find_namespace_calls(as_list = TRUE)
}
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{check_missing}()},
\code{\link{identical_structure}()},
\code{\link{input_check_response}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{print_matrix}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{packaging}
