% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdocx_document.R
\name{rdocx_document}
\alias{rdocx_document}
\title{Advanced R Markdown Word Format}
\usage{
rdocx_document(
  base_format = "rmarkdown::word_document",
  tables = list(),
  plots = list(),
  lists = list(),
  mapstyles = list(),
  reference_num = TRUE,
  ...
)
}
\arguments{
\item{base_format}{a scalar character, format to be used as a base document for
officedown. default to \link[rmarkdown:word_document]{word_document} but
can also be word_document2 from bookdown}

\item{tables}{a list that can contain few items to style tables and table captions.
Missing items will be replaced by default values. Possible items are the following:
\itemize{
\item \code{style}: the Word stylename to use for tables.
\item \code{layout}: 'autofit' or 'fixed' algorithm. See \code{\link[officer]{table_layout}}.
\item \code{width}: value of the preferred width of the table in percent (base 1).
\item \code{caption}; caption options, i.e.:
\itemize{
\item \code{style}: Word stylename to use for table captions.
\item \code{pre}: prefix for numbering chunk (default to "Table ").
\item \code{sep}: suffix for numbering chunk (default to ": ").
}
\item \code{conditional}: a list of named logical values:
\itemize{
\item \code{first_row} and \code{last_row}: apply or remove formatting from the first or last row in the table
\item \code{first_column}  and \code{last_column}: apply or remove formatting from the first or last column in the table
\item \code{no_hband} and \code{no_vband}: don't display odd and even rows or columns with alternating shading for ease of reading.
}
}

Default value is (in R format):\preformatted{list(
   style = "Table", layout = "autofit", width = 1,
   caption = list(
     style = "Table Caption", pre = "Table ", sep = ": "),
   conditional = list(
     first_row = TRUE, first_column = FALSE, last_row = FALSE,
     last_column = FALSE, no_hband = FALSE, no_vband = TRUE
   )
)
}

Default value is (in YAML format):\preformatted{style: Table
layout: autofit
width: 1.0
caption:
  style: Table Caption
  pre: 'Table '
  sep: ': '
conditional:
  first_row: true
  first_column: false
  last_row: false
  last_column: false
  no_hband: false
  no_vband: true
}}

\item{plots}{a list that can contain few items to style figures and figure captions.
Missing items will be replaced by default values. Possible items are the following:
\itemize{
\item \code{style}: the Word stylename to use for plots.
\item \code{align}: alignment of figures in the output document (possible values are 'left',
'right' and 'center').
\item \code{caption}; caption options, i.e.:
\itemize{
\item \code{style}: Word stylename to use for figure captions.
\item \code{pre}: prefix for numbering chunk (default to "Figure ").
\item \code{sep}: suffix for numbering chunk (default to ": ").
}
}

Default value is (in R format):\preformatted{list(
  style = "Normal", align = "center",
  caption = list(
    style = "Image Caption",
    pre = "Figure ",
    sep = ": "
   )
 )
}

Default value is (in YAML format):\preformatted{style: Normal
align: center
caption:
  style: Image Caption
  pre: 'Figure '
  sep: ': '
}}

\item{lists}{a list containing two named items \code{ol.style} and
\code{ul.style}, values are the stylenames to be used to replace the style of ordered
and unordered lists created by pandoc. If NULL, no replacement is made.

Default value is \code{list(ol.style = NULL, ul.style = NULL)}:\preformatted{ol.style: null
ul.style: null
}}

\item{mapstyles}{a named list of style to be replaced in the generated
document. \code{list("Normal" = c("Author", "Date"))} will result in a document where
all paragraphs styled with stylename "Date" and "Author" will be then styled with
stylename "Normal".}

\item{reference_num}{if TRUE, text for references to sections will be
the section number (e.g. '3.2'). If FALSE, text for references to sections
will be the text (e.g. 'section title').}

\item{...}{arguments used by \link[rmarkdown:word_document]{word_document}}
}
\value{
R Markdown output format to pass to \link[rmarkdown:render]{render}
}
\description{
Format for converting from R Markdown to an MS Word
document. The function comes also with improved output options.
}
\section{Finding stylenames}{


You can access them in the Word template used. Function
\link[officer:styles_info]{styles_info()} can let you read these
styles.

You need officer to read the stylenames (to get information
from a specific "reference_docx", change \code{ref_docx_default}
in the example below.\preformatted{library(officer)
docx_file <- system.file(package = "officer", "template", "template.docx")
doc <- read_docx(docx_file)
}

To read \code{paragraph} stylenames:\preformatted{styles_info(doc, type = "paragraph")
}

To read \code{table} stylenames:\preformatted{styles_info(doc, type = "table")
}

To read \code{list} stylenames:\preformatted{styles_info(doc, type = "numbering")
}
}

\section{R Markdown yaml}{

The following demonstrates how to pass arguments in the R Markdown yaml:\preformatted{---
output:
  officedown::rdocx_document:
    reference_docx: pandoc_template.docx
    tables:
      style: Table
      layout: autofit
      width: 1.0
      caption:
        style: Table Caption
        pre: 'Table '
        sep: ': '
      conditional:
        first_row: true
        first_column: false
        last_row: false
        last_column: false
        no_hband: false
        no_vband: true
    plots:
      style: Normal
      align: center
      caption:
        style: Image Caption
        pre: 'Figure '
        sep: ': '
    lists:
      ol.style: null
      ul.style: null
    mapstyles:
      Normal: ['First Paragraph', 'Author', 'Date']
    reference_num: true
---
}
}

\examples{
library(rmarkdown)
run_ok <- pandoc_available() &&
  pandoc_version() >= numeric_version("2.0")

if(run_ok){

# minimal example -----
example <- system.file(package = "officedown",
  "examples/minimal_word.Rmd")
rmd_file <- tempfile(fileext = ".Rmd")
file.copy(example, to = rmd_file)

docx_file_1 <- tempfile(fileext = ".docx")
render(rmd_file, output_file = docx_file_1, quiet = TRUE)

# bookdown example -----
if(require("bookdown")){

bookdown_loc <- system.file(package = "officedown", "examples/bookdown")

temp_dir <- tempfile()
# uncomment next line to get the result in your working directory
# temp_dir <- "./bd_example"

dir.create(temp_dir, showWarnings = FALSE, recursive = TRUE)
file.copy(
  from = list.files(bookdown_loc, full.names = TRUE),
  to = temp_dir,
  overwrite = TRUE, recursive = TRUE)

render_site(
  input = temp_dir, encoding = 'UTF-8',
  envir = new.env(), quiet = TRUE)

docx_file_2 <- file.path(temp_dir, "_book", "bookdown.docx")

if(file.exists(docx_file_2)){
  message("file ", docx_file_2, " has been written.")
}
}

}
}
