% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{prop_section}
\alias{prop_section}
\title{Section properties}
\usage{
prop_section(
  page_size = NULL,
  page_margins = NULL,
  type = NULL,
  section_columns = NULL
)
}
\arguments{
\item{page_size}{page dimensions, an object generated with function \link{page_size}.}

\item{page_margins}{page margins, an object generated with function \link{page_mar}.}

\item{type}{Section type. It defines how the contents of the section will be
placed relative to the previous section. Available types are "continuous"
(begins the section on the next paragraph), "evenPage" (begins on the next
even-numbered page), "nextColumn" (begins on the next column on the page),
"nextPage" (begins on the following page), "oddPage" (begins on the next
odd-numbered page).}

\item{section_columns}{section columns, an object generated with function \link{section_columns}.}
}
\description{
A section is a grouping of blocks (ie. paragraphs and tables)
that have a set of properties that define pages on which the text will appear.

A Section properties object stores information about page composition,
such as page size, page orientation, borders and margins.
}
\note{
There is no support yet for header and footer contents definition.
}
\section{Illustrations}{


\if{html}{\figure{prop_section_doc_1.png}{options: width=80\%}}
}

\examples{
library(officer)

landscape_one_column <- block_section(
  prop_section(
    page_size = page_size(orient = "landscape"), type = "continuous"
  )
)
landscape_two_columns <- block_section(
  prop_section(
    page_size = page_size(orient = "landscape"), type = "continuous",
    section_columns = section_columns(widths = c(4.75, 4.75))
  )
)

doc_1 <- read_docx()
# there starts section with landscape_one_column
doc_1 <- body_add_table(doc_1, value = mtcars[1:10,], style = "table_template")
doc_1 <- body_end_block_section(doc_1, value = landscape_one_column)
# there stops section with landscape_one_column


# there starts section with landscape_two_columns
doc_1 <- body_add_par(doc_1, value = paste(rep(letters, 50), collapse = " "))
doc_1 <- body_end_block_section(doc_1, value = landscape_two_columns)
# there stops section with landscape_two_columns

doc_1 <- body_add_table(doc_1, value = mtcars[1:25,], style = "table_template")

print(doc_1, target = tempfile(fileext = ".docx"))
}
\seealso{
\link{block_section}

Other functions for section definition: 
\code{\link{page_mar}()},
\code{\link{page_size}()},
\code{\link{section_columns}()}
}
\concept{functions for section definition}
