% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{inv_smax}
\alias{inv_smax}
\title{The inverse softmax function.}
\usage{
inv_smax(mu, g = NULL)
}
\arguments{
\item{mu}{a vector of the probablities.
Must be the same length as \code{g} if \code{g} is given.
If \code{mu} and \code{eta} are both given, we ignore
\code{eta} and use \code{mu}.}

\item{g}{a vector giving the group indices. If \code{NULL},
then we assume only one group is in consideration.}
}
\value{
the centered log probabilities.
}
\description{
The inverse softmax function: take a logarithm and center.
}
\details{
This is the inverse of the softmax function. Given
vector \eqn{\mu} for a single group, finds vector 
\eqn{\eta} such that
\deqn{\eta_i = \log{\mu_i} + c,}
where \eqn{c} is chosen such that the \eqn{\eta} sum 
to zero:
\deqn{c = \frac{-1}{n} \sum_i \log{\mu_i}.}
}
\note{
This function can deal with overflow in a semi-coherent way.
}
\examples{
# we can deal with large values:
set.seed(2345)
eta <- rnorm(12,sd=1000)
mu <- smax(eta)
eta0 <- inv_smax(mu)
}
\seealso{
\code{\link{smax}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
