% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwrapper.R
\name{dwrapper}
\alias{dwrapper}
\title{Ohta D Statistic Wrapper}
\usage{
dwrapper(data_set, tot_maf = 0.1, pop_maf = 0.05)
}
\arguments{
\item{data_set}{Matrix containing genotype data with individuals as rows and
loci as columns. Genotypes should be coded as 0 (homozygous), 1 (heterozygous),
or 2 (homozygous). Rownames must be subpopulation names and column names
should be marker names.}

\item{tot_maf}{Minimum minor allele frequency across the total population for
a marker to be included in the analysis.}

\item{pop_maf}{Minimum minor allele frequency across a subpopulation for
that subpopulation to be included in analysis.}
}
\value{
A list of matrices containing the pairwise comparisons for each D statistic.
Also included is the number of subpopulations evaluated in each comparison
and the ratio of d2is_mat to d2st_mat (ratio1) and dp2st_mat to dp2is_mat (ratio2).
The result of a comparison between marker M and marker N will be found in the Mth row
at the Nth column.
}
\description{
Pairwise computation of Ohta's D Statistics for each pair of polymorphisms in
a given dataset.
}
\details{
This wrapper implements the dstat function for all pairs of loci in a genotype
matrix. If the input matrix includes n loci, choose(n,2) pairs are evaluated. Therefore,
the computaiton time scales quadratically, and is not feasible for large datasets.
We suggest manual parallelization across computational nodes for a large-scale
(ie thousands of markers) implementation.
}
\examples{

data(beissinger_data)
beissinger_subset <- beissinger_data[,1:15]
dwrapper(beissinger_subset, tot_maf = 0.05, pop_maf = 0.01)

\dontrun{
data(beissinger_data)
dwrapper(beissinger_data, tot_maf = 0.05, pop_maf = 0.01)
}
}
